/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.elasticache.model.ParameterNameValue;
import software.amazon.awssdk.services.elasticache.model.ParameterNameValueListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ResetCacheParameterGroupRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ResetCacheParameterGroupRequest> {
    private final String cacheParameterGroupName;
    private final Boolean resetAllParameters;
    private final List<ParameterNameValue> parameterNameValues;

    private ResetCacheParameterGroupRequest(BuilderImpl builder) {
        this.cacheParameterGroupName = builder.cacheParameterGroupName;
        this.resetAllParameters = builder.resetAllParameters;
        this.parameterNameValues = builder.parameterNameValues;
    }

    public String cacheParameterGroupName() {
        return this.cacheParameterGroupName;
    }

    public Boolean resetAllParameters() {
        return this.resetAllParameters;
    }

    public List<ParameterNameValue> parameterNameValues() {
        return this.parameterNameValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.cacheParameterGroupName() == null ? 0 : this.cacheParameterGroupName().hashCode());
        hashCode = 31 * hashCode + (this.resetAllParameters() == null ? 0 : this.resetAllParameters().hashCode());
        hashCode = 31 * hashCode + (this.parameterNameValues() == null ? 0 : this.parameterNameValues().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetCacheParameterGroupRequest)) {
            return false;
        }
        ResetCacheParameterGroupRequest other = (ResetCacheParameterGroupRequest)((Object)obj);
        if (other.cacheParameterGroupName() == null ^ this.cacheParameterGroupName() == null) {
            return false;
        }
        if (other.cacheParameterGroupName() != null && !other.cacheParameterGroupName().equals(this.cacheParameterGroupName())) {
            return false;
        }
        if (other.resetAllParameters() == null ^ this.resetAllParameters() == null) {
            return false;
        }
        if (other.resetAllParameters() != null && !other.resetAllParameters().equals(this.resetAllParameters())) {
            return false;
        }
        if (other.parameterNameValues() == null ^ this.parameterNameValues() == null) {
            return false;
        }
        return other.parameterNameValues() == null || other.parameterNameValues().equals(this.parameterNameValues());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cacheParameterGroupName() != null) {
            sb.append("CacheParameterGroupName: ").append(this.cacheParameterGroupName()).append(",");
        }
        if (this.resetAllParameters() != null) {
            sb.append("ResetAllParameters: ").append(this.resetAllParameters()).append(",");
        }
        if (this.parameterNameValues() != null) {
            sb.append("ParameterNameValues: ").append(this.parameterNameValues()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String cacheParameterGroupName;
        private Boolean resetAllParameters;
        private List<ParameterNameValue> parameterNameValues;

        private BuilderImpl() {
        }

        private BuilderImpl(ResetCacheParameterGroupRequest model) {
            this.setCacheParameterGroupName(model.cacheParameterGroupName);
            this.setResetAllParameters(model.resetAllParameters);
            this.setParameterNameValues(model.parameterNameValues);
        }

        public final String getCacheParameterGroupName() {
            return this.cacheParameterGroupName;
        }

        @Override
        public final Builder cacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
            return this;
        }

        public final void setCacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
        }

        public final Boolean getResetAllParameters() {
            return this.resetAllParameters;
        }

        @Override
        public final Builder resetAllParameters(Boolean resetAllParameters) {
            this.resetAllParameters = resetAllParameters;
            return this;
        }

        public final void setResetAllParameters(Boolean resetAllParameters) {
            this.resetAllParameters = resetAllParameters;
        }

        public final Collection<ParameterNameValue> getParameterNameValues() {
            return this.parameterNameValues;
        }

        @Override
        public final Builder parameterNameValues(Collection<ParameterNameValue> parameterNameValues) {
            this.parameterNameValues = ParameterNameValueListCopier.copy(parameterNameValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterNameValues(ParameterNameValue ... parameterNameValues) {
            this.parameterNameValues(Arrays.asList(parameterNameValues));
            return this;
        }

        public final void setParameterNameValues(Collection<ParameterNameValue> parameterNameValues) {
            this.parameterNameValues = ParameterNameValueListCopier.copy(parameterNameValues);
        }

        @SafeVarargs
        public final void setParameterNameValues(ParameterNameValue ... parameterNameValues) {
            this.parameterNameValues(Arrays.asList(parameterNameValues));
        }

        public ResetCacheParameterGroupRequest build() {
            return new ResetCacheParameterGroupRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResetCacheParameterGroupRequest> {
        public Builder cacheParameterGroupName(String var1);

        public Builder resetAllParameters(Boolean var1);

        public Builder parameterNameValues(Collection<ParameterNameValue> var1);

        public Builder parameterNameValues(ParameterNameValue ... var1);
    }
}

