/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticache.model.RevokeCacheSecurityGroupIngressRequest;

public class RevokeCacheSecurityGroupIngressRequestMarshaller
implements Marshaller<Request<RevokeCacheSecurityGroupIngressRequest>, RevokeCacheSecurityGroupIngressRequest> {
    public Request<RevokeCacheSecurityGroupIngressRequest> marshall(RevokeCacheSecurityGroupIngressRequest revokeCacheSecurityGroupIngressRequest) {
        if (revokeCacheSecurityGroupIngressRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)revokeCacheSecurityGroupIngressRequest, "ElastiCacheClient");
        request.addParameter("Action", "RevokeCacheSecurityGroupIngress");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (revokeCacheSecurityGroupIngressRequest.cacheSecurityGroupName() != null) {
            request.addParameter("CacheSecurityGroupName", StringConversion.fromString((String)revokeCacheSecurityGroupIngressRequest.cacheSecurityGroupName()));
        }
        if (revokeCacheSecurityGroupIngressRequest.ec2SecurityGroupName() != null) {
            request.addParameter("EC2SecurityGroupName", StringConversion.fromString((String)revokeCacheSecurityGroupIngressRequest.ec2SecurityGroupName()));
        }
        if (revokeCacheSecurityGroupIngressRequest.ec2SecurityGroupOwnerId() != null) {
            request.addParameter("EC2SecurityGroupOwnerId", StringConversion.fromString((String)revokeCacheSecurityGroupIngressRequest.ec2SecurityGroupOwnerId()));
        }
        return request;
    }
}

