/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticache.model.ModifyReplicationGroupShardConfigurationRequest;
import software.amazon.awssdk.services.elasticache.model.ReshardingConfiguration;

public class ModifyReplicationGroupShardConfigurationRequestMarshaller
implements Marshaller<Request<ModifyReplicationGroupShardConfigurationRequest>, ModifyReplicationGroupShardConfigurationRequest> {
    public Request<ModifyReplicationGroupShardConfigurationRequest> marshall(ModifyReplicationGroupShardConfigurationRequest modifyReplicationGroupShardConfigurationRequest) {
        if (modifyReplicationGroupShardConfigurationRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)modifyReplicationGroupShardConfigurationRequest, "ElastiCacheClient");
        request.addParameter("Action", "ModifyReplicationGroupShardConfiguration");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyReplicationGroupShardConfigurationRequest.replicationGroupId() != null) {
            request.addParameter("ReplicationGroupId", StringConversion.fromString((String)modifyReplicationGroupShardConfigurationRequest.replicationGroupId()));
        }
        if (modifyReplicationGroupShardConfigurationRequest.nodeGroupCount() != null) {
            request.addParameter("NodeGroupCount", StringConversion.fromInteger((Integer)modifyReplicationGroupShardConfigurationRequest.nodeGroupCount()));
        }
        if (modifyReplicationGroupShardConfigurationRequest.applyImmediately() != null) {
            request.addParameter("ApplyImmediately", StringConversion.fromBoolean((Boolean)modifyReplicationGroupShardConfigurationRequest.applyImmediately()));
        }
        if (modifyReplicationGroupShardConfigurationRequest.reshardingConfiguration().isEmpty() && !(modifyReplicationGroupShardConfigurationRequest.reshardingConfiguration() instanceof SdkAutoConstructList)) {
            request.addParameter("ReshardingConfiguration", "");
        } else if (!modifyReplicationGroupShardConfigurationRequest.reshardingConfiguration().isEmpty() && !(modifyReplicationGroupShardConfigurationRequest.reshardingConfiguration() instanceof SdkAutoConstructList)) {
            List<ReshardingConfiguration> reshardingConfigurationList = modifyReplicationGroupShardConfigurationRequest.reshardingConfiguration();
            int reshardingConfigurationListIndex = 1;
            for (ReshardingConfiguration reshardingConfigurationListValue : reshardingConfigurationList) {
                if (reshardingConfigurationListValue.nodeGroupId() != null) {
                    request.addParameter("ReshardingConfiguration.ReshardingConfiguration." + reshardingConfigurationListIndex + ".NodeGroupId", StringConversion.fromString((String)reshardingConfigurationListValue.nodeGroupId()));
                }
                if (reshardingConfigurationListValue.preferredAvailabilityZones().isEmpty() && !(reshardingConfigurationListValue.preferredAvailabilityZones() instanceof SdkAutoConstructList)) {
                    request.addParameter("ReshardingConfiguration.ReshardingConfiguration." + reshardingConfigurationListIndex + ".PreferredAvailabilityZones", "");
                } else if (!reshardingConfigurationListValue.preferredAvailabilityZones().isEmpty() && !(reshardingConfigurationListValue.preferredAvailabilityZones() instanceof SdkAutoConstructList)) {
                    List<String> preferredAvailabilityZonesList = reshardingConfigurationListValue.preferredAvailabilityZones();
                    int preferredAvailabilityZonesListIndex = 1;
                    for (String preferredAvailabilityZonesListValue : preferredAvailabilityZonesList) {
                        if (preferredAvailabilityZonesListValue != null) {
                            request.addParameter("ReshardingConfiguration.ReshardingConfiguration." + reshardingConfigurationListIndex + ".PreferredAvailabilityZones.AvailabilityZone." + preferredAvailabilityZonesListIndex, StringConversion.fromString((String)preferredAvailabilityZonesListValue));
                        }
                        ++preferredAvailabilityZonesListIndex;
                    }
                }
                ++reshardingConfigurationListIndex;
            }
        }
        if (modifyReplicationGroupShardConfigurationRequest.nodeGroupsToRemove().isEmpty() && !(modifyReplicationGroupShardConfigurationRequest.nodeGroupsToRemove() instanceof SdkAutoConstructList)) {
            request.addParameter("NodeGroupsToRemove", "");
        } else if (!modifyReplicationGroupShardConfigurationRequest.nodeGroupsToRemove().isEmpty() && !(modifyReplicationGroupShardConfigurationRequest.nodeGroupsToRemove() instanceof SdkAutoConstructList)) {
            List<String> nodeGroupsToRemoveList = modifyReplicationGroupShardConfigurationRequest.nodeGroupsToRemove();
            int nodeGroupsToRemoveListIndex = 1;
            for (String nodeGroupsToRemoveListValue : nodeGroupsToRemoveList) {
                if (nodeGroupsToRemoveListValue != null) {
                    request.addParameter("NodeGroupsToRemove.NodeGroupToRemove." + nodeGroupsToRemoveListIndex, StringConversion.fromString((String)nodeGroupsToRemoveListValue));
                }
                ++nodeGroupsToRemoveListIndex;
            }
        }
        if (modifyReplicationGroupShardConfigurationRequest.nodeGroupsToRetain().isEmpty() && !(modifyReplicationGroupShardConfigurationRequest.nodeGroupsToRetain() instanceof SdkAutoConstructList)) {
            request.addParameter("NodeGroupsToRetain", "");
        } else if (!modifyReplicationGroupShardConfigurationRequest.nodeGroupsToRetain().isEmpty() && !(modifyReplicationGroupShardConfigurationRequest.nodeGroupsToRetain() instanceof SdkAutoConstructList)) {
            List<String> nodeGroupsToRetainList = modifyReplicationGroupShardConfigurationRequest.nodeGroupsToRetain();
            int nodeGroupsToRetainListIndex = 1;
            for (String nodeGroupsToRetainListValue : nodeGroupsToRetainList) {
                if (nodeGroupsToRetainListValue != null) {
                    request.addParameter("NodeGroupsToRetain.NodeGroupToRetain." + nodeGroupsToRetainListIndex, StringConversion.fromString((String)nodeGroupsToRetainListValue));
                }
                ++nodeGroupsToRetainListIndex;
            }
        }
        return request;
    }
}

