/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticache.model.DescribeEngineDefaultParametersRequest;

public class DescribeEngineDefaultParametersRequestMarshaller
implements Marshaller<Request<DescribeEngineDefaultParametersRequest>, DescribeEngineDefaultParametersRequest> {
    public Request<DescribeEngineDefaultParametersRequest> marshall(DescribeEngineDefaultParametersRequest describeEngineDefaultParametersRequest) {
        if (describeEngineDefaultParametersRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeEngineDefaultParametersRequest, "ElastiCacheClient");
        request.addParameter("Action", "DescribeEngineDefaultParameters");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeEngineDefaultParametersRequest.cacheParameterGroupFamily() != null) {
            request.addParameter("CacheParameterGroupFamily", StringConversion.fromString((String)describeEngineDefaultParametersRequest.cacheParameterGroupFamily()));
        }
        if (describeEngineDefaultParametersRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeEngineDefaultParametersRequest.maxRecords()));
        }
        if (describeEngineDefaultParametersRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)describeEngineDefaultParametersRequest.marker()));
        }
        return request;
    }
}

