/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersRequest;

public class DescribeCacheClustersRequestMarshaller
implements Marshaller<Request<DescribeCacheClustersRequest>, DescribeCacheClustersRequest> {
    public Request<DescribeCacheClustersRequest> marshall(DescribeCacheClustersRequest describeCacheClustersRequest) {
        if (describeCacheClustersRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeCacheClustersRequest, "ElastiCacheClient");
        request.addParameter("Action", "DescribeCacheClusters");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeCacheClustersRequest.cacheClusterId() != null) {
            request.addParameter("CacheClusterId", StringConversion.fromString((String)describeCacheClustersRequest.cacheClusterId()));
        }
        if (describeCacheClustersRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeCacheClustersRequest.maxRecords()));
        }
        if (describeCacheClustersRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)describeCacheClustersRequest.marker()));
        }
        if (describeCacheClustersRequest.showCacheNodeInfo() != null) {
            request.addParameter("ShowCacheNodeInfo", StringConversion.fromBoolean((Boolean)describeCacheClustersRequest.showCacheNodeInfo()));
        }
        if (describeCacheClustersRequest.showCacheClustersNotInReplicationGroups() != null) {
            request.addParameter("ShowCacheClustersNotInReplicationGroups", StringConversion.fromBoolean((Boolean)describeCacheClustersRequest.showCacheClustersNotInReplicationGroups()));
        }
        return request;
    }
}

