/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticache.model.ConfigureShard;
import software.amazon.awssdk.services.elasticache.model.DecreaseReplicaCountRequest;

public class DecreaseReplicaCountRequestMarshaller
implements Marshaller<Request<DecreaseReplicaCountRequest>, DecreaseReplicaCountRequest> {
    public Request<DecreaseReplicaCountRequest> marshall(DecreaseReplicaCountRequest decreaseReplicaCountRequest) {
        if (decreaseReplicaCountRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)decreaseReplicaCountRequest, "ElastiCacheClient");
        request.addParameter("Action", "DecreaseReplicaCount");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (decreaseReplicaCountRequest.replicationGroupId() != null) {
            request.addParameter("ReplicationGroupId", StringConversion.fromString((String)decreaseReplicaCountRequest.replicationGroupId()));
        }
        if (decreaseReplicaCountRequest.newReplicaCount() != null) {
            request.addParameter("NewReplicaCount", StringConversion.fromInteger((Integer)decreaseReplicaCountRequest.newReplicaCount()));
        }
        if (decreaseReplicaCountRequest.replicaConfiguration().isEmpty() && !(decreaseReplicaCountRequest.replicaConfiguration() instanceof SdkAutoConstructList)) {
            request.addParameter("ReplicaConfiguration", "");
        } else if (!decreaseReplicaCountRequest.replicaConfiguration().isEmpty() && !(decreaseReplicaCountRequest.replicaConfiguration() instanceof SdkAutoConstructList)) {
            List<ConfigureShard> replicaConfigurationList = decreaseReplicaCountRequest.replicaConfiguration();
            int replicaConfigurationListIndex = 1;
            for (ConfigureShard replicaConfigurationListValue : replicaConfigurationList) {
                if (replicaConfigurationListValue.nodeGroupId() != null) {
                    request.addParameter("ReplicaConfiguration.ConfigureShard." + replicaConfigurationListIndex + ".NodeGroupId", StringConversion.fromString((String)replicaConfigurationListValue.nodeGroupId()));
                }
                if (replicaConfigurationListValue.newReplicaCount() != null) {
                    request.addParameter("ReplicaConfiguration.ConfigureShard." + replicaConfigurationListIndex + ".NewReplicaCount", StringConversion.fromInteger((Integer)replicaConfigurationListValue.newReplicaCount()));
                }
                if (replicaConfigurationListValue.preferredAvailabilityZones().isEmpty() && !(replicaConfigurationListValue.preferredAvailabilityZones() instanceof SdkAutoConstructList)) {
                    request.addParameter("ReplicaConfiguration.ConfigureShard." + replicaConfigurationListIndex + ".PreferredAvailabilityZones", "");
                } else if (!replicaConfigurationListValue.preferredAvailabilityZones().isEmpty() && !(replicaConfigurationListValue.preferredAvailabilityZones() instanceof SdkAutoConstructList)) {
                    List<String> preferredAvailabilityZonesList = replicaConfigurationListValue.preferredAvailabilityZones();
                    int preferredAvailabilityZonesListIndex = 1;
                    for (String preferredAvailabilityZonesListValue : preferredAvailabilityZonesList) {
                        if (preferredAvailabilityZonesListValue != null) {
                            request.addParameter("ReplicaConfiguration.ConfigureShard." + replicaConfigurationListIndex + ".PreferredAvailabilityZones.PreferredAvailabilityZone." + preferredAvailabilityZonesListIndex, StringConversion.fromString((String)preferredAvailabilityZonesListValue));
                        }
                        ++preferredAvailabilityZonesListIndex;
                    }
                }
                ++replicaConfigurationListIndex;
            }
        }
        if (decreaseReplicaCountRequest.replicasToRemove().isEmpty() && !(decreaseReplicaCountRequest.replicasToRemove() instanceof SdkAutoConstructList)) {
            request.addParameter("ReplicasToRemove", "");
        } else if (!decreaseReplicaCountRequest.replicasToRemove().isEmpty() && !(decreaseReplicaCountRequest.replicasToRemove() instanceof SdkAutoConstructList)) {
            List<String> replicasToRemoveList = decreaseReplicaCountRequest.replicasToRemove();
            int replicasToRemoveListIndex = 1;
            for (String replicasToRemoveListValue : replicasToRemoveList) {
                if (replicasToRemoveListValue != null) {
                    request.addParameter("ReplicasToRemove.member." + replicasToRemoveListIndex, StringConversion.fromString((String)replicasToRemoveListValue));
                }
                ++replicasToRemoveListIndex;
            }
        }
        if (decreaseReplicaCountRequest.applyImmediately() != null) {
            request.addParameter("ApplyImmediately", StringConversion.fromBoolean((Boolean)decreaseReplicaCountRequest.applyImmediately()));
        }
        return request;
    }
}

