/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticache.model.CopySnapshotRequest;

public class CopySnapshotRequestMarshaller
implements Marshaller<Request<CopySnapshotRequest>, CopySnapshotRequest> {
    public Request<CopySnapshotRequest> marshall(CopySnapshotRequest copySnapshotRequest) {
        if (copySnapshotRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)copySnapshotRequest, "ElastiCacheClient");
        request.addParameter("Action", "CopySnapshot");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (copySnapshotRequest.sourceSnapshotName() != null) {
            request.addParameter("SourceSnapshotName", StringConversion.fromString((String)copySnapshotRequest.sourceSnapshotName()));
        }
        if (copySnapshotRequest.targetSnapshotName() != null) {
            request.addParameter("TargetSnapshotName", StringConversion.fromString((String)copySnapshotRequest.targetSnapshotName()));
        }
        if (copySnapshotRequest.targetBucket() != null) {
            request.addParameter("TargetBucket", StringConversion.fromString((String)copySnapshotRequest.targetBucket()));
        }
        return request;
    }
}

