/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RevokeCacheSecurityGroupIngressRequest
extends ElastiCacheRequest
implements ToCopyableBuilder<Builder, RevokeCacheSecurityGroupIngressRequest> {
    private final String cacheSecurityGroupName;
    private final String ec2SecurityGroupName;
    private final String ec2SecurityGroupOwnerId;

    private RevokeCacheSecurityGroupIngressRequest(BuilderImpl builder) {
        super(builder);
        this.cacheSecurityGroupName = builder.cacheSecurityGroupName;
        this.ec2SecurityGroupName = builder.ec2SecurityGroupName;
        this.ec2SecurityGroupOwnerId = builder.ec2SecurityGroupOwnerId;
    }

    public String cacheSecurityGroupName() {
        return this.cacheSecurityGroupName;
    }

    public String ec2SecurityGroupName() {
        return this.ec2SecurityGroupName;
    }

    public String ec2SecurityGroupOwnerId() {
        return this.ec2SecurityGroupOwnerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheSecurityGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2SecurityGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2SecurityGroupOwnerId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevokeCacheSecurityGroupIngressRequest)) {
            return false;
        }
        RevokeCacheSecurityGroupIngressRequest other = (RevokeCacheSecurityGroupIngressRequest)((Object)obj);
        return Objects.equals(this.cacheSecurityGroupName(), other.cacheSecurityGroupName()) && Objects.equals(this.ec2SecurityGroupName(), other.ec2SecurityGroupName()) && Objects.equals(this.ec2SecurityGroupOwnerId(), other.ec2SecurityGroupOwnerId());
    }

    public String toString() {
        return ToString.builder((String)"RevokeCacheSecurityGroupIngressRequest").add("CacheSecurityGroupName", (Object)this.cacheSecurityGroupName()).add("EC2SecurityGroupName", (Object)this.ec2SecurityGroupName()).add("EC2SecurityGroupOwnerId", (Object)this.ec2SecurityGroupOwnerId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CacheSecurityGroupName": {
                return Optional.ofNullable(clazz.cast(this.cacheSecurityGroupName()));
            }
            case "EC2SecurityGroupName": {
                return Optional.ofNullable(clazz.cast(this.ec2SecurityGroupName()));
            }
            case "EC2SecurityGroupOwnerId": {
                return Optional.ofNullable(clazz.cast(this.ec2SecurityGroupOwnerId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElastiCacheRequest.BuilderImpl
    implements Builder {
        private String cacheSecurityGroupName;
        private String ec2SecurityGroupName;
        private String ec2SecurityGroupOwnerId;

        private BuilderImpl() {
        }

        private BuilderImpl(RevokeCacheSecurityGroupIngressRequest model) {
            super(model);
            this.cacheSecurityGroupName(model.cacheSecurityGroupName);
            this.ec2SecurityGroupName(model.ec2SecurityGroupName);
            this.ec2SecurityGroupOwnerId(model.ec2SecurityGroupOwnerId);
        }

        public final String getCacheSecurityGroupName() {
            return this.cacheSecurityGroupName;
        }

        @Override
        public final Builder cacheSecurityGroupName(String cacheSecurityGroupName) {
            this.cacheSecurityGroupName = cacheSecurityGroupName;
            return this;
        }

        public final void setCacheSecurityGroupName(String cacheSecurityGroupName) {
            this.cacheSecurityGroupName = cacheSecurityGroupName;
        }

        public final String getEC2SecurityGroupName() {
            return this.ec2SecurityGroupName;
        }

        @Override
        public final Builder ec2SecurityGroupName(String ec2SecurityGroupName) {
            this.ec2SecurityGroupName = ec2SecurityGroupName;
            return this;
        }

        public final void setEC2SecurityGroupName(String ec2SecurityGroupName) {
            this.ec2SecurityGroupName = ec2SecurityGroupName;
        }

        public final String getEC2SecurityGroupOwnerId() {
            return this.ec2SecurityGroupOwnerId;
        }

        @Override
        public final Builder ec2SecurityGroupOwnerId(String ec2SecurityGroupOwnerId) {
            this.ec2SecurityGroupOwnerId = ec2SecurityGroupOwnerId;
            return this;
        }

        public final void setEC2SecurityGroupOwnerId(String ec2SecurityGroupOwnerId) {
            this.ec2SecurityGroupOwnerId = ec2SecurityGroupOwnerId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RevokeCacheSecurityGroupIngressRequest build() {
            return new RevokeCacheSecurityGroupIngressRequest(this);
        }
    }

    public static interface Builder
    extends ElastiCacheRequest.Builder,
    CopyableBuilder<Builder, RevokeCacheSecurityGroupIngressRequest> {
        public Builder cacheSecurityGroupName(String var1);

        public Builder ec2SecurityGroupName(String var1);

        public Builder ec2SecurityGroupOwnerId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

