/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticache.model.ParameterNameValue;
import software.amazon.awssdk.services.elasticache.model.ResetCacheParameterGroupRequest;

public class ResetCacheParameterGroupRequestMarshaller
implements Marshaller<Request<ResetCacheParameterGroupRequest>, ResetCacheParameterGroupRequest> {
    public Request<ResetCacheParameterGroupRequest> marshall(ResetCacheParameterGroupRequest resetCacheParameterGroupRequest) {
        if (resetCacheParameterGroupRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)resetCacheParameterGroupRequest, "ElastiCacheClient");
        request.addParameter("Action", "ResetCacheParameterGroup");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (resetCacheParameterGroupRequest.cacheParameterGroupName() != null) {
            request.addParameter("CacheParameterGroupName", StringConversion.fromString((String)resetCacheParameterGroupRequest.cacheParameterGroupName()));
        }
        if (resetCacheParameterGroupRequest.resetAllParameters() != null) {
            request.addParameter("ResetAllParameters", StringConversion.fromBoolean((Boolean)resetCacheParameterGroupRequest.resetAllParameters()));
        }
        if (resetCacheParameterGroupRequest.parameterNameValues().isEmpty() && !(resetCacheParameterGroupRequest.parameterNameValues() instanceof SdkAutoConstructList)) {
            request.addParameter("ParameterNameValues", "");
        } else if (!resetCacheParameterGroupRequest.parameterNameValues().isEmpty() && !(resetCacheParameterGroupRequest.parameterNameValues() instanceof SdkAutoConstructList)) {
            List<ParameterNameValue> parameterNameValuesList = resetCacheParameterGroupRequest.parameterNameValues();
            int parameterNameValuesListIndex = 1;
            for (ParameterNameValue parameterNameValuesListValue : parameterNameValuesList) {
                if (parameterNameValuesListValue.parameterName() != null) {
                    request.addParameter("ParameterNameValues.ParameterNameValue." + parameterNameValuesListIndex + ".ParameterName", StringConversion.fromString((String)parameterNameValuesListValue.parameterName()));
                }
                if (parameterNameValuesListValue.parameterValue() != null) {
                    request.addParameter("ParameterNameValues.ParameterNameValue." + parameterNameValuesListIndex + ".ParameterValue", StringConversion.fromString((String)parameterNameValuesListValue.parameterValue()));
                }
                ++parameterNameValuesListIndex;
            }
        }
        return request;
    }
}

