/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticache.model.RemoveTagsFromResourceRequest;

public class RemoveTagsFromResourceRequestMarshaller
implements Marshaller<Request<RemoveTagsFromResourceRequest>, RemoveTagsFromResourceRequest> {
    public Request<RemoveTagsFromResourceRequest> marshall(RemoveTagsFromResourceRequest removeTagsFromResourceRequest) {
        if (removeTagsFromResourceRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)removeTagsFromResourceRequest, "ElastiCacheClient");
        request.addParameter("Action", "RemoveTagsFromResource");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (removeTagsFromResourceRequest.resourceName() != null) {
            request.addParameter("ResourceName", StringConversion.fromString((String)removeTagsFromResourceRequest.resourceName()));
        }
        if (removeTagsFromResourceRequest.tagKeys().isEmpty() && !(removeTagsFromResourceRequest.tagKeys() instanceof SdkAutoConstructList)) {
            request.addParameter("TagKeys", "");
        } else if (!removeTagsFromResourceRequest.tagKeys().isEmpty() && !(removeTagsFromResourceRequest.tagKeys() instanceof SdkAutoConstructList)) {
            List<String> tagKeysList = removeTagsFromResourceRequest.tagKeys();
            int tagKeysListIndex = 1;
            for (String tagKeysListValue : tagKeysList) {
                if (tagKeysListValue != null) {
                    request.addParameter("TagKeys.member." + tagKeysListIndex, StringConversion.fromString((String)tagKeysListValue));
                }
                ++tagKeysListIndex;
            }
        }
        return request;
    }
}

