/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticache.model.CreateCacheSubnetGroupRequest;

public class CreateCacheSubnetGroupRequestMarshaller
implements Marshaller<Request<CreateCacheSubnetGroupRequest>, CreateCacheSubnetGroupRequest> {
    public Request<CreateCacheSubnetGroupRequest> marshall(CreateCacheSubnetGroupRequest createCacheSubnetGroupRequest) {
        if (createCacheSubnetGroupRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createCacheSubnetGroupRequest, "ElastiCacheClient");
        request.addParameter("Action", "CreateCacheSubnetGroup");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (createCacheSubnetGroupRequest.cacheSubnetGroupName() != null) {
            request.addParameter("CacheSubnetGroupName", StringConversion.fromString((String)createCacheSubnetGroupRequest.cacheSubnetGroupName()));
        }
        if (createCacheSubnetGroupRequest.cacheSubnetGroupDescription() != null) {
            request.addParameter("CacheSubnetGroupDescription", StringConversion.fromString((String)createCacheSubnetGroupRequest.cacheSubnetGroupDescription()));
        }
        if (createCacheSubnetGroupRequest.subnetIds().isEmpty() && !(createCacheSubnetGroupRequest.subnetIds() instanceof SdkAutoConstructList)) {
            request.addParameter("SubnetIds", "");
        } else if (!createCacheSubnetGroupRequest.subnetIds().isEmpty() && !(createCacheSubnetGroupRequest.subnetIds() instanceof SdkAutoConstructList)) {
            List<String> subnetIdsList = createCacheSubnetGroupRequest.subnetIds();
            int subnetIdsListIndex = 1;
            for (String subnetIdsListValue : subnetIdsList) {
                if (subnetIdsListValue != null) {
                    request.addParameter("SubnetIds.SubnetIdentifier." + subnetIdsListIndex, StringConversion.fromString((String)subnetIdsListValue));
                }
                ++subnetIdsListIndex;
            }
        }
        return request;
    }
}

