/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.AvailabilityZonesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReshardingConfiguration
implements ToCopyableBuilder<Builder, ReshardingConfiguration> {
    private final List<String> preferredAvailabilityZones;

    private ReshardingConfiguration(BuilderImpl builder) {
        this.preferredAvailabilityZones = builder.preferredAvailabilityZones;
    }

    public List<String> preferredAvailabilityZones() {
        return this.preferredAvailabilityZones;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredAvailabilityZones());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReshardingConfiguration)) {
            return false;
        }
        ReshardingConfiguration other = (ReshardingConfiguration)obj;
        return Objects.equals(this.preferredAvailabilityZones(), other.preferredAvailabilityZones());
    }

    public String toString() {
        return ToString.builder((String)"ReshardingConfiguration").add("PreferredAvailabilityZones", this.preferredAvailabilityZones()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PreferredAvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.preferredAvailabilityZones()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> preferredAvailabilityZones = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReshardingConfiguration model) {
            this.preferredAvailabilityZones(model.preferredAvailabilityZones);
        }

        public final Collection<String> getPreferredAvailabilityZones() {
            return this.preferredAvailabilityZones;
        }

        @Override
        public final Builder preferredAvailabilityZones(Collection<String> preferredAvailabilityZones) {
            this.preferredAvailabilityZones = AvailabilityZonesListCopier.copy(preferredAvailabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder preferredAvailabilityZones(String ... preferredAvailabilityZones) {
            this.preferredAvailabilityZones(Arrays.asList(preferredAvailabilityZones));
            return this;
        }

        public final void setPreferredAvailabilityZones(Collection<String> preferredAvailabilityZones) {
            this.preferredAvailabilityZones = AvailabilityZonesListCopier.copy(preferredAvailabilityZones);
        }

        public ReshardingConfiguration build() {
            return new ReshardingConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReshardingConfiguration> {
        public Builder preferredAvailabilityZones(Collection<String> var1);

        public Builder preferredAvailabilityZones(String ... var1);
    }
}

