/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CopySnapshotRequest
extends ElastiCacheRequest
implements ToCopyableBuilder<Builder, CopySnapshotRequest> {
    private final String sourceSnapshotName;
    private final String targetSnapshotName;
    private final String targetBucket;

    private CopySnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.sourceSnapshotName = builder.sourceSnapshotName;
        this.targetSnapshotName = builder.targetSnapshotName;
        this.targetBucket = builder.targetBucket;
    }

    public String sourceSnapshotName() {
        return this.sourceSnapshotName;
    }

    public String targetSnapshotName() {
        return this.targetSnapshotName;
    }

    public String targetBucket() {
        return this.targetBucket;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceSnapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetSnapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetBucket());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopySnapshotRequest)) {
            return false;
        }
        CopySnapshotRequest other = (CopySnapshotRequest)((Object)obj);
        return Objects.equals(this.sourceSnapshotName(), other.sourceSnapshotName()) && Objects.equals(this.targetSnapshotName(), other.targetSnapshotName()) && Objects.equals(this.targetBucket(), other.targetBucket());
    }

    public String toString() {
        return ToString.builder((String)"CopySnapshotRequest").add("SourceSnapshotName", (Object)this.sourceSnapshotName()).add("TargetSnapshotName", (Object)this.targetSnapshotName()).add("TargetBucket", (Object)this.targetBucket()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceSnapshotName": {
                return Optional.ofNullable(clazz.cast(this.sourceSnapshotName()));
            }
            case "TargetSnapshotName": {
                return Optional.ofNullable(clazz.cast(this.targetSnapshotName()));
            }
            case "TargetBucket": {
                return Optional.ofNullable(clazz.cast(this.targetBucket()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElastiCacheRequest.BuilderImpl
    implements Builder {
        private String sourceSnapshotName;
        private String targetSnapshotName;
        private String targetBucket;

        private BuilderImpl() {
        }

        private BuilderImpl(CopySnapshotRequest model) {
            super(model);
            this.sourceSnapshotName(model.sourceSnapshotName);
            this.targetSnapshotName(model.targetSnapshotName);
            this.targetBucket(model.targetBucket);
        }

        public final String getSourceSnapshotName() {
            return this.sourceSnapshotName;
        }

        @Override
        public final Builder sourceSnapshotName(String sourceSnapshotName) {
            this.sourceSnapshotName = sourceSnapshotName;
            return this;
        }

        public final void setSourceSnapshotName(String sourceSnapshotName) {
            this.sourceSnapshotName = sourceSnapshotName;
        }

        public final String getTargetSnapshotName() {
            return this.targetSnapshotName;
        }

        @Override
        public final Builder targetSnapshotName(String targetSnapshotName) {
            this.targetSnapshotName = targetSnapshotName;
            return this;
        }

        public final void setTargetSnapshotName(String targetSnapshotName) {
            this.targetSnapshotName = targetSnapshotName;
        }

        public final String getTargetBucket() {
            return this.targetBucket;
        }

        @Override
        public final Builder targetBucket(String targetBucket) {
            this.targetBucket = targetBucket;
            return this;
        }

        public final void setTargetBucket(String targetBucket) {
            this.targetBucket = targetBucket;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopySnapshotRequest build() {
            return new CopySnapshotRequest(this);
        }
    }

    public static interface Builder
    extends ElastiCacheRequest.Builder,
    CopyableBuilder<Builder, CopySnapshotRequest> {
        public Builder sourceSnapshotName(String var1);

        public Builder targetSnapshotName(String var1);

        public Builder targetBucket(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

