/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticache.model.CreateReplicationGroupRequest;
import software.amazon.awssdk.services.elasticache.model.NodeGroupConfiguration;
import software.amazon.awssdk.services.elasticache.model.Tag;

public class CreateReplicationGroupRequestMarshaller
implements Marshaller<Request<CreateReplicationGroupRequest>, CreateReplicationGroupRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<CreateReplicationGroupRequest> marshall(CreateReplicationGroupRequest createReplicationGroupRequest) {
        List<String> list;
        List<Tag> list2;
        List<String> list3;
        List<String> cacheSecurityGroupNamesList;
        List<NodeGroupConfiguration> nodeGroupConfigurationList;
        List<String> preferredCacheClusterAZsList;
        if (createReplicationGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)createReplicationGroupRequest, "ElastiCacheClient");
        request.addParameter("Action", "CreateReplicationGroup");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (createReplicationGroupRequest.replicationGroupId() != null) {
            request.addParameter("ReplicationGroupId", StringUtils.fromString((String)createReplicationGroupRequest.replicationGroupId()));
        }
        if (createReplicationGroupRequest.replicationGroupDescription() != null) {
            request.addParameter("ReplicationGroupDescription", StringUtils.fromString((String)createReplicationGroupRequest.replicationGroupDescription()));
        }
        if (createReplicationGroupRequest.primaryClusterId() != null) {
            request.addParameter("PrimaryClusterId", StringUtils.fromString((String)createReplicationGroupRequest.primaryClusterId()));
        }
        if (createReplicationGroupRequest.automaticFailoverEnabled() != null) {
            request.addParameter("AutomaticFailoverEnabled", StringUtils.fromBoolean((Boolean)createReplicationGroupRequest.automaticFailoverEnabled()));
        }
        if (createReplicationGroupRequest.numCacheClusters() != null) {
            request.addParameter("NumCacheClusters", StringUtils.fromInteger((Integer)createReplicationGroupRequest.numCacheClusters()));
        }
        if ((preferredCacheClusterAZsList = createReplicationGroupRequest.preferredCacheClusterAZs()) != null) {
            if (!preferredCacheClusterAZsList.isEmpty()) {
                int preferredCacheClusterAZsListIndex = 1;
                for (String string : preferredCacheClusterAZsList) {
                    if (string != null) {
                        request.addParameter("PreferredCacheClusterAZs.AvailabilityZone." + preferredCacheClusterAZsListIndex, StringUtils.fromString((String)string));
                    }
                    ++preferredCacheClusterAZsListIndex;
                }
            } else {
                request.addParameter("PreferredCacheClusterAZs", "");
            }
        }
        if (createReplicationGroupRequest.numNodeGroups() != null) {
            request.addParameter("NumNodeGroups", StringUtils.fromInteger((Integer)createReplicationGroupRequest.numNodeGroups()));
        }
        if (createReplicationGroupRequest.replicasPerNodeGroup() != null) {
            request.addParameter("ReplicasPerNodeGroup", StringUtils.fromInteger((Integer)createReplicationGroupRequest.replicasPerNodeGroup()));
        }
        if ((nodeGroupConfigurationList = createReplicationGroupRequest.nodeGroupConfiguration()) != null) {
            if (!nodeGroupConfigurationList.isEmpty()) {
                int nodeGroupConfigurationListIndex = 1;
                for (NodeGroupConfiguration nodeGroupConfiguration : nodeGroupConfigurationList) {
                    List<String> list4;
                    if (nodeGroupConfiguration.slots() != null) {
                        request.addParameter("NodeGroupConfiguration.NodeGroupConfiguration." + nodeGroupConfigurationListIndex + ".Slots", StringUtils.fromString((String)nodeGroupConfiguration.slots()));
                    }
                    if (nodeGroupConfiguration.replicaCount() != null) {
                        request.addParameter("NodeGroupConfiguration.NodeGroupConfiguration." + nodeGroupConfigurationListIndex + ".ReplicaCount", StringUtils.fromInteger((Integer)nodeGroupConfiguration.replicaCount()));
                    }
                    if (nodeGroupConfiguration.primaryAvailabilityZone() != null) {
                        request.addParameter("NodeGroupConfiguration.NodeGroupConfiguration." + nodeGroupConfigurationListIndex + ".PrimaryAvailabilityZone", StringUtils.fromString((String)nodeGroupConfiguration.primaryAvailabilityZone()));
                    }
                    if ((list4 = nodeGroupConfiguration.replicaAvailabilityZones()) != null) {
                        if (!list4.isEmpty()) {
                            int replicaAvailabilityZonesListIndex = 1;
                            for (String replicaAvailabilityZonesListValue : list4) {
                                if (replicaAvailabilityZonesListValue != null) {
                                    request.addParameter("NodeGroupConfiguration.NodeGroupConfiguration." + nodeGroupConfigurationListIndex + ".ReplicaAvailabilityZones.AvailabilityZone." + replicaAvailabilityZonesListIndex, StringUtils.fromString((String)replicaAvailabilityZonesListValue));
                                }
                                ++replicaAvailabilityZonesListIndex;
                            }
                        } else {
                            request.addParameter("NodeGroupConfiguration.NodeGroupConfiguration." + nodeGroupConfigurationListIndex + ".ReplicaAvailabilityZones", "");
                        }
                    }
                    ++nodeGroupConfigurationListIndex;
                }
            } else {
                request.addParameter("NodeGroupConfiguration", "");
            }
        }
        if (createReplicationGroupRequest.cacheNodeType() != null) {
            request.addParameter("CacheNodeType", StringUtils.fromString((String)createReplicationGroupRequest.cacheNodeType()));
        }
        if (createReplicationGroupRequest.engine() != null) {
            request.addParameter("Engine", StringUtils.fromString((String)createReplicationGroupRequest.engine()));
        }
        if (createReplicationGroupRequest.engineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString((String)createReplicationGroupRequest.engineVersion()));
        }
        if (createReplicationGroupRequest.cacheParameterGroupName() != null) {
            request.addParameter("CacheParameterGroupName", StringUtils.fromString((String)createReplicationGroupRequest.cacheParameterGroupName()));
        }
        if (createReplicationGroupRequest.cacheSubnetGroupName() != null) {
            request.addParameter("CacheSubnetGroupName", StringUtils.fromString((String)createReplicationGroupRequest.cacheSubnetGroupName()));
        }
        if ((cacheSecurityGroupNamesList = createReplicationGroupRequest.cacheSecurityGroupNames()) != null) {
            if (!cacheSecurityGroupNamesList.isEmpty()) {
                boolean bl = true;
                for (String string : cacheSecurityGroupNamesList) {
                    void var6_12;
                    if (string != null) {
                        request.addParameter("CacheSecurityGroupNames.CacheSecurityGroupName." + (int)var6_12, StringUtils.fromString((String)string));
                    }
                    ++var6_12;
                }
            } else {
                request.addParameter("CacheSecurityGroupNames", "");
            }
        }
        if ((list3 = createReplicationGroupRequest.securityGroupIds()) != null) {
            if (!list3.isEmpty()) {
                boolean bl = true;
                for (String securityGroupIdsListValue : list3) {
                    void var7_18;
                    if (securityGroupIdsListValue != null) {
                        request.addParameter("SecurityGroupIds.SecurityGroupId." + (int)var7_18, StringUtils.fromString((String)securityGroupIdsListValue));
                    }
                    ++var7_18;
                }
            } else {
                request.addParameter("SecurityGroupIds", "");
            }
        }
        if ((list2 = createReplicationGroupRequest.tags()) != null) {
            if (!list2.isEmpty()) {
                boolean bl = true;
                for (Tag tagsListValue : list2) {
                    void var8_26;
                    if (tagsListValue.key() != null) {
                        request.addParameter("Tags.Tag." + (int)var8_26 + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                    }
                    if (tagsListValue.value() != null) {
                        request.addParameter("Tags.Tag." + (int)var8_26 + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                    }
                    ++var8_26;
                }
            } else {
                request.addParameter("Tags", "");
            }
        }
        if ((list = createReplicationGroupRequest.snapshotArns()) != null) {
            if (!list.isEmpty()) {
                int snapshotArnsListIndex = 1;
                for (String snapshotArnsListValue : list) {
                    if (snapshotArnsListValue != null) {
                        request.addParameter("SnapshotArns.SnapshotArn." + snapshotArnsListIndex, StringUtils.fromString((String)snapshotArnsListValue));
                    }
                    ++snapshotArnsListIndex;
                }
            } else {
                request.addParameter("SnapshotArns", "");
            }
        }
        if (createReplicationGroupRequest.snapshotName() != null) {
            request.addParameter("SnapshotName", StringUtils.fromString((String)createReplicationGroupRequest.snapshotName()));
        }
        if (createReplicationGroupRequest.preferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringUtils.fromString((String)createReplicationGroupRequest.preferredMaintenanceWindow()));
        }
        if (createReplicationGroupRequest.port() != null) {
            request.addParameter("Port", StringUtils.fromInteger((Integer)createReplicationGroupRequest.port()));
        }
        if (createReplicationGroupRequest.notificationTopicArn() != null) {
            request.addParameter("NotificationTopicArn", StringUtils.fromString((String)createReplicationGroupRequest.notificationTopicArn()));
        }
        if (createReplicationGroupRequest.autoMinorVersionUpgrade() != null) {
            request.addParameter("AutoMinorVersionUpgrade", StringUtils.fromBoolean((Boolean)createReplicationGroupRequest.autoMinorVersionUpgrade()));
        }
        if (createReplicationGroupRequest.snapshotRetentionLimit() != null) {
            request.addParameter("SnapshotRetentionLimit", StringUtils.fromInteger((Integer)createReplicationGroupRequest.snapshotRetentionLimit()));
        }
        if (createReplicationGroupRequest.snapshotWindow() != null) {
            request.addParameter("SnapshotWindow", StringUtils.fromString((String)createReplicationGroupRequest.snapshotWindow()));
        }
        if (createReplicationGroupRequest.authToken() != null) {
            request.addParameter("AuthToken", StringUtils.fromString((String)createReplicationGroupRequest.authToken()));
        }
        if (createReplicationGroupRequest.transitEncryptionEnabled() != null) {
            request.addParameter("TransitEncryptionEnabled", StringUtils.fromBoolean((Boolean)createReplicationGroupRequest.transitEncryptionEnabled()));
        }
        if (createReplicationGroupRequest.atRestEncryptionEnabled() != null) {
            request.addParameter("AtRestEncryptionEnabled", StringUtils.fromBoolean((Boolean)createReplicationGroupRequest.atRestEncryptionEnabled()));
        }
        return request;
    }
}

