/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.elasticache.ElastiCacheAsyncClient;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheParametersRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheParametersResponse;
import software.amazon.awssdk.services.elasticache.model.Parameter;

public class DescribeCacheParametersPublisher
implements SdkPublisher<DescribeCacheParametersResponse> {
    private final ElastiCacheAsyncClient client;
    private final DescribeCacheParametersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeCacheParametersPublisher(ElastiCacheAsyncClient client, DescribeCacheParametersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeCacheParametersPublisher(ElastiCacheAsyncClient client, DescribeCacheParametersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeCacheParametersResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeCacheParametersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<Parameter> parameters() {
        Function<DescribeCacheParametersResponse, Iterator> getIterator = response -> {
            if (response != null && response.parameters() != null) {
                return response.parameters().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new DescribeCacheParametersResponseFetcher(), getIterator, this.isLastPage);
    }

    public final DescribeCacheParametersPublisher resume(DescribeCacheParametersResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeCacheParametersPublisher(this.client, (DescribeCacheParametersRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeCacheParametersPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeCacheParametersResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeCacheParametersResponseFetcher
    implements AsyncPageFetcher<DescribeCacheParametersResponse> {
        private DescribeCacheParametersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCacheParametersResponse previousPage) {
            return previousPage.marker() != null;
        }

        public CompletableFuture<DescribeCacheParametersResponse> nextPage(DescribeCacheParametersResponse previousPage) {
            if (previousPage == null) {
                return DescribeCacheParametersPublisher.this.client.describeCacheParameters(DescribeCacheParametersPublisher.this.firstRequest);
            }
            return DescribeCacheParametersPublisher.this.client.describeCacheParameters((DescribeCacheParametersRequest)((Object)DescribeCacheParametersPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

