/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeReservedCacheNodesOfferingsRequest
extends ElastiCacheRequest
implements ToCopyableBuilder<Builder, DescribeReservedCacheNodesOfferingsRequest> {
    private final String reservedCacheNodesOfferingId;
    private final String cacheNodeType;
    private final String duration;
    private final String productDescription;
    private final String offeringType;
    private final Integer maxRecords;
    private final String marker;

    private DescribeReservedCacheNodesOfferingsRequest(BuilderImpl builder) {
        super(builder);
        this.reservedCacheNodesOfferingId = builder.reservedCacheNodesOfferingId;
        this.cacheNodeType = builder.cacheNodeType;
        this.duration = builder.duration;
        this.productDescription = builder.productDescription;
        this.offeringType = builder.offeringType;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
    }

    public String reservedCacheNodesOfferingId() {
        return this.reservedCacheNodesOfferingId;
    }

    public String cacheNodeType() {
        return this.cacheNodeType;
    }

    public String duration() {
        return this.duration;
    }

    public String productDescription() {
        return this.productDescription;
    }

    public String offeringType() {
        return this.offeringType;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    public String marker() {
        return this.marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedCacheNodesOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheNodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.productDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringType());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedCacheNodesOfferingsRequest)) {
            return false;
        }
        DescribeReservedCacheNodesOfferingsRequest other = (DescribeReservedCacheNodesOfferingsRequest)((Object)obj);
        return Objects.equals(this.reservedCacheNodesOfferingId(), other.reservedCacheNodesOfferingId()) && Objects.equals(this.cacheNodeType(), other.cacheNodeType()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.productDescription(), other.productDescription()) && Objects.equals(this.offeringType(), other.offeringType()) && Objects.equals(this.maxRecords(), other.maxRecords()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"DescribeReservedCacheNodesOfferingsRequest").add("ReservedCacheNodesOfferingId", (Object)this.reservedCacheNodesOfferingId()).add("CacheNodeType", (Object)this.cacheNodeType()).add("Duration", (Object)this.duration()).add("ProductDescription", (Object)this.productDescription()).add("OfferingType", (Object)this.offeringType()).add("MaxRecords", (Object)this.maxRecords()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservedCacheNodesOfferingId": {
                return Optional.of(clazz.cast(this.reservedCacheNodesOfferingId()));
            }
            case "CacheNodeType": {
                return Optional.of(clazz.cast(this.cacheNodeType()));
            }
            case "Duration": {
                return Optional.of(clazz.cast(this.duration()));
            }
            case "ProductDescription": {
                return Optional.of(clazz.cast(this.productDescription()));
            }
            case "OfferingType": {
                return Optional.of(clazz.cast(this.offeringType()));
            }
            case "MaxRecords": {
                return Optional.of(clazz.cast(this.maxRecords()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElastiCacheRequest.BuilderImpl
    implements Builder {
        private String reservedCacheNodesOfferingId;
        private String cacheNodeType;
        private String duration;
        private String productDescription;
        private String offeringType;
        private Integer maxRecords;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedCacheNodesOfferingsRequest model) {
            super(model);
            this.reservedCacheNodesOfferingId(model.reservedCacheNodesOfferingId);
            this.cacheNodeType(model.cacheNodeType);
            this.duration(model.duration);
            this.productDescription(model.productDescription);
            this.offeringType(model.offeringType);
            this.maxRecords(model.maxRecords);
            this.marker(model.marker);
        }

        public final String getReservedCacheNodesOfferingId() {
            return this.reservedCacheNodesOfferingId;
        }

        @Override
        public final Builder reservedCacheNodesOfferingId(String reservedCacheNodesOfferingId) {
            this.reservedCacheNodesOfferingId = reservedCacheNodesOfferingId;
            return this;
        }

        public final void setReservedCacheNodesOfferingId(String reservedCacheNodesOfferingId) {
            this.reservedCacheNodesOfferingId = reservedCacheNodesOfferingId;
        }

        public final String getCacheNodeType() {
            return this.cacheNodeType;
        }

        @Override
        public final Builder cacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
            return this;
        }

        public final void setCacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
        }

        public final String getDuration() {
            return this.duration;
        }

        @Override
        public final Builder duration(String duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(String duration) {
            this.duration = duration;
        }

        public final String getProductDescription() {
            return this.productDescription;
        }

        @Override
        public final Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        public final void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        public final String getOfferingType() {
            return this.offeringType;
        }

        @Override
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeReservedCacheNodesOfferingsRequest build() {
            return new DescribeReservedCacheNodesOfferingsRequest(this);
        }
    }

    public static interface Builder
    extends ElastiCacheRequest.Builder,
    CopyableBuilder<Builder, DescribeReservedCacheNodesOfferingsRequest> {
        public Builder reservedCacheNodesOfferingId(String var1);

        public Builder cacheNodeType(String var1);

        public Builder duration(String var1);

        public Builder productDescription(String var1);

        public Builder offeringType(String var1);

        public Builder maxRecords(Integer var1);

        public Builder marker(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

