/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticache.model.ParameterNameValue;
import software.amazon.awssdk.services.elasticache.model.ResetCacheParameterGroupRequest;
import software.amazon.awssdk.util.StringUtils;

public class ResetCacheParameterGroupRequestMarshaller
implements Marshaller<Request<ResetCacheParameterGroupRequest>, ResetCacheParameterGroupRequest> {
    public Request<ResetCacheParameterGroupRequest> marshall(ResetCacheParameterGroupRequest resetCacheParameterGroupRequest) {
        SdkInternalList parameterNameValuesList;
        if (resetCacheParameterGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)resetCacheParameterGroupRequest, "ElastiCacheClient");
        request.addParameter("Action", "ResetCacheParameterGroup");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (resetCacheParameterGroupRequest.cacheParameterGroupName() != null) {
            request.addParameter("CacheParameterGroupName", StringUtils.fromString((String)resetCacheParameterGroupRequest.cacheParameterGroupName()));
        }
        if (resetCacheParameterGroupRequest.resetAllParameters() != null) {
            request.addParameter("ResetAllParameters", StringUtils.fromBoolean((Boolean)resetCacheParameterGroupRequest.resetAllParameters()));
        }
        if (!(parameterNameValuesList = (SdkInternalList)resetCacheParameterGroupRequest.parameterNameValues()).isEmpty() || !parameterNameValuesList.isAutoConstruct()) {
            int parameterNameValuesListIndex = 1;
            for (ParameterNameValue parameterNameValuesListValue : parameterNameValuesList) {
                if (parameterNameValuesListValue.parameterName() != null) {
                    request.addParameter("ParameterNameValues.ParameterNameValue." + parameterNameValuesListIndex + ".ParameterName", StringUtils.fromString((String)parameterNameValuesListValue.parameterName()));
                }
                if (parameterNameValuesListValue.parameterValue() != null) {
                    request.addParameter("ParameterNameValues.ParameterNameValue." + parameterNameValuesListIndex + ".ParameterValue", StringUtils.fromString((String)parameterNameValuesListValue.parameterValue()));
                }
                ++parameterNameValuesListIndex;
            }
        }
        return request;
    }
}

