/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.elasticache.model.CacheNodeTypeSpecificParameter;
import software.amazon.awssdk.services.elasticache.model.CacheNodeTypeSpecificParametersListCopier;
import software.amazon.awssdk.services.elasticache.model.Parameter;
import software.amazon.awssdk.services.elasticache.model.ParametersListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeCacheParametersResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeCacheParametersResponse> {
    private final String marker;
    private final List<Parameter> parameters;
    private final List<CacheNodeTypeSpecificParameter> cacheNodeTypeSpecificParameters;

    private DescribeCacheParametersResponse(BuilderImpl builder) {
        this.marker = builder.marker;
        this.parameters = builder.parameters;
        this.cacheNodeTypeSpecificParameters = builder.cacheNodeTypeSpecificParameters;
    }

    public String marker() {
        return this.marker;
    }

    public List<Parameter> parameters() {
        return this.parameters;
    }

    public List<CacheNodeTypeSpecificParameter> cacheNodeTypeSpecificParameters() {
        return this.cacheNodeTypeSpecificParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.parameters() == null ? 0 : this.parameters().hashCode());
        hashCode = 31 * hashCode + (this.cacheNodeTypeSpecificParameters() == null ? 0 : this.cacheNodeTypeSpecificParameters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCacheParametersResponse)) {
            return false;
        }
        DescribeCacheParametersResponse other = (DescribeCacheParametersResponse)((Object)obj);
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        if (other.parameters() != null && !other.parameters().equals(this.parameters())) {
            return false;
        }
        if (other.cacheNodeTypeSpecificParameters() == null ^ this.cacheNodeTypeSpecificParameters() == null) {
            return false;
        }
        return other.cacheNodeTypeSpecificParameters() == null || other.cacheNodeTypeSpecificParameters().equals(this.cacheNodeTypeSpecificParameters());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.parameters() != null) {
            sb.append("Parameters: ").append(this.parameters()).append(",");
        }
        if (this.cacheNodeTypeSpecificParameters() != null) {
            sb.append("CacheNodeTypeSpecificParameters: ").append(this.cacheNodeTypeSpecificParameters()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String marker;
        private List<Parameter> parameters = new SdkInternalList();
        private List<CacheNodeTypeSpecificParameter> cacheNodeTypeSpecificParameters = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCacheParametersResponse model) {
            this.setMarker(model.marker);
            this.setParameters(model.parameters);
            this.setCacheNodeTypeSpecificParameters(model.cacheNodeTypeSpecificParameters);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<Parameter> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParametersListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter ... parameters) {
            if (this.parameters == null) {
                this.parameters = new SdkInternalList(parameters.length);
            }
            for (Parameter e : parameters) {
                this.parameters.add(e);
            }
            return this;
        }

        public final void setParameters(Collection<Parameter> parameters) {
            this.parameters = ParametersListCopier.copy(parameters);
        }

        @SafeVarargs
        public final void setParameters(Parameter ... parameters) {
            if (this.parameters == null) {
                this.parameters = new SdkInternalList(parameters.length);
            }
            for (Parameter e : parameters) {
                this.parameters.add(e);
            }
        }

        public final Collection<CacheNodeTypeSpecificParameter> getCacheNodeTypeSpecificParameters() {
            return this.cacheNodeTypeSpecificParameters;
        }

        @Override
        public final Builder cacheNodeTypeSpecificParameters(Collection<CacheNodeTypeSpecificParameter> cacheNodeTypeSpecificParameters) {
            this.cacheNodeTypeSpecificParameters = CacheNodeTypeSpecificParametersListCopier.copy(cacheNodeTypeSpecificParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheNodeTypeSpecificParameters(CacheNodeTypeSpecificParameter ... cacheNodeTypeSpecificParameters) {
            if (this.cacheNodeTypeSpecificParameters == null) {
                this.cacheNodeTypeSpecificParameters = new SdkInternalList(cacheNodeTypeSpecificParameters.length);
            }
            for (CacheNodeTypeSpecificParameter e : cacheNodeTypeSpecificParameters) {
                this.cacheNodeTypeSpecificParameters.add(e);
            }
            return this;
        }

        public final void setCacheNodeTypeSpecificParameters(Collection<CacheNodeTypeSpecificParameter> cacheNodeTypeSpecificParameters) {
            this.cacheNodeTypeSpecificParameters = CacheNodeTypeSpecificParametersListCopier.copy(cacheNodeTypeSpecificParameters);
        }

        @SafeVarargs
        public final void setCacheNodeTypeSpecificParameters(CacheNodeTypeSpecificParameter ... cacheNodeTypeSpecificParameters) {
            if (this.cacheNodeTypeSpecificParameters == null) {
                this.cacheNodeTypeSpecificParameters = new SdkInternalList(cacheNodeTypeSpecificParameters.length);
            }
            for (CacheNodeTypeSpecificParameter e : cacheNodeTypeSpecificParameters) {
                this.cacheNodeTypeSpecificParameters.add(e);
            }
        }

        public DescribeCacheParametersResponse build() {
            return new DescribeCacheParametersResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeCacheParametersResponse> {
        public Builder marker(String var1);

        public Builder parameters(Collection<Parameter> var1);

        public Builder parameters(Parameter ... var1);

        public Builder cacheNodeTypeSpecificParameters(Collection<CacheNodeTypeSpecificParameter> var1);

        public Builder cacheNodeTypeSpecificParameters(CacheNodeTypeSpecificParameter ... var1);
    }
}

