/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.elasticache.model.CacheNode;
import software.amazon.awssdk.services.elasticache.model.CacheNodeListCopier;
import software.amazon.awssdk.services.elasticache.model.CacheParameterGroupStatus;
import software.amazon.awssdk.services.elasticache.model.CacheSecurityGroupMembership;
import software.amazon.awssdk.services.elasticache.model.CacheSecurityGroupMembershipListCopier;
import software.amazon.awssdk.services.elasticache.model.Endpoint;
import software.amazon.awssdk.services.elasticache.model.NotificationConfiguration;
import software.amazon.awssdk.services.elasticache.model.PendingModifiedValues;
import software.amazon.awssdk.services.elasticache.model.SecurityGroupMembership;
import software.amazon.awssdk.services.elasticache.model.SecurityGroupMembershipListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CacheCluster
implements ToCopyableBuilder<Builder, CacheCluster> {
    private final String cacheClusterId;
    private final Endpoint configurationEndpoint;
    private final String clientDownloadLandingPage;
    private final String cacheNodeType;
    private final String engine;
    private final String engineVersion;
    private final String cacheClusterStatus;
    private final Integer numCacheNodes;
    private final String preferredAvailabilityZone;
    private final Date cacheClusterCreateTime;
    private final String preferredMaintenanceWindow;
    private final PendingModifiedValues pendingModifiedValues;
    private final NotificationConfiguration notificationConfiguration;
    private final List<CacheSecurityGroupMembership> cacheSecurityGroups;
    private final CacheParameterGroupStatus cacheParameterGroup;
    private final String cacheSubnetGroupName;
    private final List<CacheNode> cacheNodes;
    private final Boolean autoMinorVersionUpgrade;
    private final List<SecurityGroupMembership> securityGroups;
    private final String replicationGroupId;
    private final Integer snapshotRetentionLimit;
    private final String snapshotWindow;

    private CacheCluster(BuilderImpl builder) {
        this.cacheClusterId = builder.cacheClusterId;
        this.configurationEndpoint = builder.configurationEndpoint;
        this.clientDownloadLandingPage = builder.clientDownloadLandingPage;
        this.cacheNodeType = builder.cacheNodeType;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.cacheClusterStatus = builder.cacheClusterStatus;
        this.numCacheNodes = builder.numCacheNodes;
        this.preferredAvailabilityZone = builder.preferredAvailabilityZone;
        this.cacheClusterCreateTime = builder.cacheClusterCreateTime;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.pendingModifiedValues = builder.pendingModifiedValues;
        this.notificationConfiguration = builder.notificationConfiguration;
        this.cacheSecurityGroups = builder.cacheSecurityGroups;
        this.cacheParameterGroup = builder.cacheParameterGroup;
        this.cacheSubnetGroupName = builder.cacheSubnetGroupName;
        this.cacheNodes = builder.cacheNodes;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.securityGroups = builder.securityGroups;
        this.replicationGroupId = builder.replicationGroupId;
        this.snapshotRetentionLimit = builder.snapshotRetentionLimit;
        this.snapshotWindow = builder.snapshotWindow;
    }

    public String cacheClusterId() {
        return this.cacheClusterId;
    }

    public Endpoint configurationEndpoint() {
        return this.configurationEndpoint;
    }

    public String clientDownloadLandingPage() {
        return this.clientDownloadLandingPage;
    }

    public String cacheNodeType() {
        return this.cacheNodeType;
    }

    public String engine() {
        return this.engine;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public String cacheClusterStatus() {
        return this.cacheClusterStatus;
    }

    public Integer numCacheNodes() {
        return this.numCacheNodes;
    }

    public String preferredAvailabilityZone() {
        return this.preferredAvailabilityZone;
    }

    public Date cacheClusterCreateTime() {
        return this.cacheClusterCreateTime;
    }

    public String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public PendingModifiedValues pendingModifiedValues() {
        return this.pendingModifiedValues;
    }

    public NotificationConfiguration notificationConfiguration() {
        return this.notificationConfiguration;
    }

    public List<CacheSecurityGroupMembership> cacheSecurityGroups() {
        return this.cacheSecurityGroups;
    }

    public CacheParameterGroupStatus cacheParameterGroup() {
        return this.cacheParameterGroup;
    }

    public String cacheSubnetGroupName() {
        return this.cacheSubnetGroupName;
    }

    public List<CacheNode> cacheNodes() {
        return this.cacheNodes;
    }

    public Boolean autoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public List<SecurityGroupMembership> securityGroups() {
        return this.securityGroups;
    }

    public String replicationGroupId() {
        return this.replicationGroupId;
    }

    public Integer snapshotRetentionLimit() {
        return this.snapshotRetentionLimit;
    }

    public String snapshotWindow() {
        return this.snapshotWindow;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.cacheClusterId() == null ? 0 : this.cacheClusterId().hashCode());
        hashCode = 31 * hashCode + (this.configurationEndpoint() == null ? 0 : this.configurationEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.clientDownloadLandingPage() == null ? 0 : this.clientDownloadLandingPage().hashCode());
        hashCode = 31 * hashCode + (this.cacheNodeType() == null ? 0 : this.cacheNodeType().hashCode());
        hashCode = 31 * hashCode + (this.engine() == null ? 0 : this.engine().hashCode());
        hashCode = 31 * hashCode + (this.engineVersion() == null ? 0 : this.engineVersion().hashCode());
        hashCode = 31 * hashCode + (this.cacheClusterStatus() == null ? 0 : this.cacheClusterStatus().hashCode());
        hashCode = 31 * hashCode + (this.numCacheNodes() == null ? 0 : this.numCacheNodes().hashCode());
        hashCode = 31 * hashCode + (this.preferredAvailabilityZone() == null ? 0 : this.preferredAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.cacheClusterCreateTime() == null ? 0 : this.cacheClusterCreateTime().hashCode());
        hashCode = 31 * hashCode + (this.preferredMaintenanceWindow() == null ? 0 : this.preferredMaintenanceWindow().hashCode());
        hashCode = 31 * hashCode + (this.pendingModifiedValues() == null ? 0 : this.pendingModifiedValues().hashCode());
        hashCode = 31 * hashCode + (this.notificationConfiguration() == null ? 0 : this.notificationConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.cacheSecurityGroups() == null ? 0 : this.cacheSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.cacheParameterGroup() == null ? 0 : this.cacheParameterGroup().hashCode());
        hashCode = 31 * hashCode + (this.cacheSubnetGroupName() == null ? 0 : this.cacheSubnetGroupName().hashCode());
        hashCode = 31 * hashCode + (this.cacheNodes() == null ? 0 : this.cacheNodes().hashCode());
        hashCode = 31 * hashCode + (this.autoMinorVersionUpgrade() == null ? 0 : this.autoMinorVersionUpgrade().hashCode());
        hashCode = 31 * hashCode + (this.securityGroups() == null ? 0 : this.securityGroups().hashCode());
        hashCode = 31 * hashCode + (this.replicationGroupId() == null ? 0 : this.replicationGroupId().hashCode());
        hashCode = 31 * hashCode + (this.snapshotRetentionLimit() == null ? 0 : this.snapshotRetentionLimit().hashCode());
        hashCode = 31 * hashCode + (this.snapshotWindow() == null ? 0 : this.snapshotWindow().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CacheCluster)) {
            return false;
        }
        CacheCluster other = (CacheCluster)obj;
        if (other.cacheClusterId() == null ^ this.cacheClusterId() == null) {
            return false;
        }
        if (other.cacheClusterId() != null && !other.cacheClusterId().equals(this.cacheClusterId())) {
            return false;
        }
        if (other.configurationEndpoint() == null ^ this.configurationEndpoint() == null) {
            return false;
        }
        if (other.configurationEndpoint() != null && !other.configurationEndpoint().equals(this.configurationEndpoint())) {
            return false;
        }
        if (other.clientDownloadLandingPage() == null ^ this.clientDownloadLandingPage() == null) {
            return false;
        }
        if (other.clientDownloadLandingPage() != null && !other.clientDownloadLandingPage().equals(this.clientDownloadLandingPage())) {
            return false;
        }
        if (other.cacheNodeType() == null ^ this.cacheNodeType() == null) {
            return false;
        }
        if (other.cacheNodeType() != null && !other.cacheNodeType().equals(this.cacheNodeType())) {
            return false;
        }
        if (other.engine() == null ^ this.engine() == null) {
            return false;
        }
        if (other.engine() != null && !other.engine().equals(this.engine())) {
            return false;
        }
        if (other.engineVersion() == null ^ this.engineVersion() == null) {
            return false;
        }
        if (other.engineVersion() != null && !other.engineVersion().equals(this.engineVersion())) {
            return false;
        }
        if (other.cacheClusterStatus() == null ^ this.cacheClusterStatus() == null) {
            return false;
        }
        if (other.cacheClusterStatus() != null && !other.cacheClusterStatus().equals(this.cacheClusterStatus())) {
            return false;
        }
        if (other.numCacheNodes() == null ^ this.numCacheNodes() == null) {
            return false;
        }
        if (other.numCacheNodes() != null && !other.numCacheNodes().equals(this.numCacheNodes())) {
            return false;
        }
        if (other.preferredAvailabilityZone() == null ^ this.preferredAvailabilityZone() == null) {
            return false;
        }
        if (other.preferredAvailabilityZone() != null && !other.preferredAvailabilityZone().equals(this.preferredAvailabilityZone())) {
            return false;
        }
        if (other.cacheClusterCreateTime() == null ^ this.cacheClusterCreateTime() == null) {
            return false;
        }
        if (other.cacheClusterCreateTime() != null && !other.cacheClusterCreateTime().equals(this.cacheClusterCreateTime())) {
            return false;
        }
        if (other.preferredMaintenanceWindow() == null ^ this.preferredMaintenanceWindow() == null) {
            return false;
        }
        if (other.preferredMaintenanceWindow() != null && !other.preferredMaintenanceWindow().equals(this.preferredMaintenanceWindow())) {
            return false;
        }
        if (other.pendingModifiedValues() == null ^ this.pendingModifiedValues() == null) {
            return false;
        }
        if (other.pendingModifiedValues() != null && !other.pendingModifiedValues().equals(this.pendingModifiedValues())) {
            return false;
        }
        if (other.notificationConfiguration() == null ^ this.notificationConfiguration() == null) {
            return false;
        }
        if (other.notificationConfiguration() != null && !other.notificationConfiguration().equals(this.notificationConfiguration())) {
            return false;
        }
        if (other.cacheSecurityGroups() == null ^ this.cacheSecurityGroups() == null) {
            return false;
        }
        if (other.cacheSecurityGroups() != null && !other.cacheSecurityGroups().equals(this.cacheSecurityGroups())) {
            return false;
        }
        if (other.cacheParameterGroup() == null ^ this.cacheParameterGroup() == null) {
            return false;
        }
        if (other.cacheParameterGroup() != null && !other.cacheParameterGroup().equals(this.cacheParameterGroup())) {
            return false;
        }
        if (other.cacheSubnetGroupName() == null ^ this.cacheSubnetGroupName() == null) {
            return false;
        }
        if (other.cacheSubnetGroupName() != null && !other.cacheSubnetGroupName().equals(this.cacheSubnetGroupName())) {
            return false;
        }
        if (other.cacheNodes() == null ^ this.cacheNodes() == null) {
            return false;
        }
        if (other.cacheNodes() != null && !other.cacheNodes().equals(this.cacheNodes())) {
            return false;
        }
        if (other.autoMinorVersionUpgrade() == null ^ this.autoMinorVersionUpgrade() == null) {
            return false;
        }
        if (other.autoMinorVersionUpgrade() != null && !other.autoMinorVersionUpgrade().equals(this.autoMinorVersionUpgrade())) {
            return false;
        }
        if (other.securityGroups() == null ^ this.securityGroups() == null) {
            return false;
        }
        if (other.securityGroups() != null && !other.securityGroups().equals(this.securityGroups())) {
            return false;
        }
        if (other.replicationGroupId() == null ^ this.replicationGroupId() == null) {
            return false;
        }
        if (other.replicationGroupId() != null && !other.replicationGroupId().equals(this.replicationGroupId())) {
            return false;
        }
        if (other.snapshotRetentionLimit() == null ^ this.snapshotRetentionLimit() == null) {
            return false;
        }
        if (other.snapshotRetentionLimit() != null && !other.snapshotRetentionLimit().equals(this.snapshotRetentionLimit())) {
            return false;
        }
        if (other.snapshotWindow() == null ^ this.snapshotWindow() == null) {
            return false;
        }
        return other.snapshotWindow() == null || other.snapshotWindow().equals(this.snapshotWindow());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cacheClusterId() != null) {
            sb.append("CacheClusterId: ").append(this.cacheClusterId()).append(",");
        }
        if (this.configurationEndpoint() != null) {
            sb.append("ConfigurationEndpoint: ").append(this.configurationEndpoint()).append(",");
        }
        if (this.clientDownloadLandingPage() != null) {
            sb.append("ClientDownloadLandingPage: ").append(this.clientDownloadLandingPage()).append(",");
        }
        if (this.cacheNodeType() != null) {
            sb.append("CacheNodeType: ").append(this.cacheNodeType()).append(",");
        }
        if (this.engine() != null) {
            sb.append("Engine: ").append(this.engine()).append(",");
        }
        if (this.engineVersion() != null) {
            sb.append("EngineVersion: ").append(this.engineVersion()).append(",");
        }
        if (this.cacheClusterStatus() != null) {
            sb.append("CacheClusterStatus: ").append(this.cacheClusterStatus()).append(",");
        }
        if (this.numCacheNodes() != null) {
            sb.append("NumCacheNodes: ").append(this.numCacheNodes()).append(",");
        }
        if (this.preferredAvailabilityZone() != null) {
            sb.append("PreferredAvailabilityZone: ").append(this.preferredAvailabilityZone()).append(",");
        }
        if (this.cacheClusterCreateTime() != null) {
            sb.append("CacheClusterCreateTime: ").append(this.cacheClusterCreateTime()).append(",");
        }
        if (this.preferredMaintenanceWindow() != null) {
            sb.append("PreferredMaintenanceWindow: ").append(this.preferredMaintenanceWindow()).append(",");
        }
        if (this.pendingModifiedValues() != null) {
            sb.append("PendingModifiedValues: ").append(this.pendingModifiedValues()).append(",");
        }
        if (this.notificationConfiguration() != null) {
            sb.append("NotificationConfiguration: ").append(this.notificationConfiguration()).append(",");
        }
        if (this.cacheSecurityGroups() != null) {
            sb.append("CacheSecurityGroups: ").append(this.cacheSecurityGroups()).append(",");
        }
        if (this.cacheParameterGroup() != null) {
            sb.append("CacheParameterGroup: ").append(this.cacheParameterGroup()).append(",");
        }
        if (this.cacheSubnetGroupName() != null) {
            sb.append("CacheSubnetGroupName: ").append(this.cacheSubnetGroupName()).append(",");
        }
        if (this.cacheNodes() != null) {
            sb.append("CacheNodes: ").append(this.cacheNodes()).append(",");
        }
        if (this.autoMinorVersionUpgrade() != null) {
            sb.append("AutoMinorVersionUpgrade: ").append(this.autoMinorVersionUpgrade()).append(",");
        }
        if (this.securityGroups() != null) {
            sb.append("SecurityGroups: ").append(this.securityGroups()).append(",");
        }
        if (this.replicationGroupId() != null) {
            sb.append("ReplicationGroupId: ").append(this.replicationGroupId()).append(",");
        }
        if (this.snapshotRetentionLimit() != null) {
            sb.append("SnapshotRetentionLimit: ").append(this.snapshotRetentionLimit()).append(",");
        }
        if (this.snapshotWindow() != null) {
            sb.append("SnapshotWindow: ").append(this.snapshotWindow()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String cacheClusterId;
        private Endpoint configurationEndpoint;
        private String clientDownloadLandingPage;
        private String cacheNodeType;
        private String engine;
        private String engineVersion;
        private String cacheClusterStatus;
        private Integer numCacheNodes;
        private String preferredAvailabilityZone;
        private Date cacheClusterCreateTime;
        private String preferredMaintenanceWindow;
        private PendingModifiedValues pendingModifiedValues;
        private NotificationConfiguration notificationConfiguration;
        private List<CacheSecurityGroupMembership> cacheSecurityGroups = new SdkInternalList();
        private CacheParameterGroupStatus cacheParameterGroup;
        private String cacheSubnetGroupName;
        private List<CacheNode> cacheNodes = new SdkInternalList();
        private Boolean autoMinorVersionUpgrade;
        private List<SecurityGroupMembership> securityGroups = new SdkInternalList();
        private String replicationGroupId;
        private Integer snapshotRetentionLimit;
        private String snapshotWindow;

        private BuilderImpl() {
        }

        private BuilderImpl(CacheCluster model) {
            this.setCacheClusterId(model.cacheClusterId);
            this.setConfigurationEndpoint(model.configurationEndpoint);
            this.setClientDownloadLandingPage(model.clientDownloadLandingPage);
            this.setCacheNodeType(model.cacheNodeType);
            this.setEngine(model.engine);
            this.setEngineVersion(model.engineVersion);
            this.setCacheClusterStatus(model.cacheClusterStatus);
            this.setNumCacheNodes(model.numCacheNodes);
            this.setPreferredAvailabilityZone(model.preferredAvailabilityZone);
            this.setCacheClusterCreateTime(model.cacheClusterCreateTime);
            this.setPreferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.setPendingModifiedValues(model.pendingModifiedValues);
            this.setNotificationConfiguration(model.notificationConfiguration);
            this.setCacheSecurityGroups(model.cacheSecurityGroups);
            this.setCacheParameterGroup(model.cacheParameterGroup);
            this.setCacheSubnetGroupName(model.cacheSubnetGroupName);
            this.setCacheNodes(model.cacheNodes);
            this.setAutoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            this.setSecurityGroups(model.securityGroups);
            this.setReplicationGroupId(model.replicationGroupId);
            this.setSnapshotRetentionLimit(model.snapshotRetentionLimit);
            this.setSnapshotWindow(model.snapshotWindow);
        }

        public final String getCacheClusterId() {
            return this.cacheClusterId;
        }

        @Override
        public final Builder cacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
            return this;
        }

        public final void setCacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
        }

        public final Endpoint getConfigurationEndpoint() {
            return this.configurationEndpoint;
        }

        @Override
        public final Builder configurationEndpoint(Endpoint configurationEndpoint) {
            this.configurationEndpoint = configurationEndpoint;
            return this;
        }

        public final void setConfigurationEndpoint(Endpoint configurationEndpoint) {
            this.configurationEndpoint = configurationEndpoint;
        }

        public final String getClientDownloadLandingPage() {
            return this.clientDownloadLandingPage;
        }

        @Override
        public final Builder clientDownloadLandingPage(String clientDownloadLandingPage) {
            this.clientDownloadLandingPage = clientDownloadLandingPage;
            return this;
        }

        public final void setClientDownloadLandingPage(String clientDownloadLandingPage) {
            this.clientDownloadLandingPage = clientDownloadLandingPage;
        }

        public final String getCacheNodeType() {
            return this.cacheNodeType;
        }

        @Override
        public final Builder cacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
            return this;
        }

        public final void setCacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getCacheClusterStatus() {
            return this.cacheClusterStatus;
        }

        @Override
        public final Builder cacheClusterStatus(String cacheClusterStatus) {
            this.cacheClusterStatus = cacheClusterStatus;
            return this;
        }

        public final void setCacheClusterStatus(String cacheClusterStatus) {
            this.cacheClusterStatus = cacheClusterStatus;
        }

        public final Integer getNumCacheNodes() {
            return this.numCacheNodes;
        }

        @Override
        public final Builder numCacheNodes(Integer numCacheNodes) {
            this.numCacheNodes = numCacheNodes;
            return this;
        }

        public final void setNumCacheNodes(Integer numCacheNodes) {
            this.numCacheNodes = numCacheNodes;
        }

        public final String getPreferredAvailabilityZone() {
            return this.preferredAvailabilityZone;
        }

        @Override
        public final Builder preferredAvailabilityZone(String preferredAvailabilityZone) {
            this.preferredAvailabilityZone = preferredAvailabilityZone;
            return this;
        }

        public final void setPreferredAvailabilityZone(String preferredAvailabilityZone) {
            this.preferredAvailabilityZone = preferredAvailabilityZone;
        }

        public final Date getCacheClusterCreateTime() {
            return this.cacheClusterCreateTime;
        }

        @Override
        public final Builder cacheClusterCreateTime(Date cacheClusterCreateTime) {
            this.cacheClusterCreateTime = StandardMemberCopier.copy((Date)cacheClusterCreateTime);
            return this;
        }

        public final void setCacheClusterCreateTime(Date cacheClusterCreateTime) {
            this.cacheClusterCreateTime = StandardMemberCopier.copy((Date)cacheClusterCreateTime);
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final PendingModifiedValues getPendingModifiedValues() {
            return this.pendingModifiedValues;
        }

        @Override
        public final Builder pendingModifiedValues(PendingModifiedValues pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues;
            return this;
        }

        public final void setPendingModifiedValues(PendingModifiedValues pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues;
        }

        public final NotificationConfiguration getNotificationConfiguration() {
            return this.notificationConfiguration;
        }

        @Override
        public final Builder notificationConfiguration(NotificationConfiguration notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration;
            return this;
        }

        public final void setNotificationConfiguration(NotificationConfiguration notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration;
        }

        public final Collection<CacheSecurityGroupMembership> getCacheSecurityGroups() {
            return this.cacheSecurityGroups;
        }

        @Override
        public final Builder cacheSecurityGroups(Collection<CacheSecurityGroupMembership> cacheSecurityGroups) {
            this.cacheSecurityGroups = CacheSecurityGroupMembershipListCopier.copy(cacheSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheSecurityGroups(CacheSecurityGroupMembership ... cacheSecurityGroups) {
            if (this.cacheSecurityGroups == null) {
                this.cacheSecurityGroups = new SdkInternalList(cacheSecurityGroups.length);
            }
            for (CacheSecurityGroupMembership e : cacheSecurityGroups) {
                this.cacheSecurityGroups.add(e);
            }
            return this;
        }

        public final void setCacheSecurityGroups(Collection<CacheSecurityGroupMembership> cacheSecurityGroups) {
            this.cacheSecurityGroups = CacheSecurityGroupMembershipListCopier.copy(cacheSecurityGroups);
        }

        @SafeVarargs
        public final void setCacheSecurityGroups(CacheSecurityGroupMembership ... cacheSecurityGroups) {
            if (this.cacheSecurityGroups == null) {
                this.cacheSecurityGroups = new SdkInternalList(cacheSecurityGroups.length);
            }
            for (CacheSecurityGroupMembership e : cacheSecurityGroups) {
                this.cacheSecurityGroups.add(e);
            }
        }

        public final CacheParameterGroupStatus getCacheParameterGroup() {
            return this.cacheParameterGroup;
        }

        @Override
        public final Builder cacheParameterGroup(CacheParameterGroupStatus cacheParameterGroup) {
            this.cacheParameterGroup = cacheParameterGroup;
            return this;
        }

        public final void setCacheParameterGroup(CacheParameterGroupStatus cacheParameterGroup) {
            this.cacheParameterGroup = cacheParameterGroup;
        }

        public final String getCacheSubnetGroupName() {
            return this.cacheSubnetGroupName;
        }

        @Override
        public final Builder cacheSubnetGroupName(String cacheSubnetGroupName) {
            this.cacheSubnetGroupName = cacheSubnetGroupName;
            return this;
        }

        public final void setCacheSubnetGroupName(String cacheSubnetGroupName) {
            this.cacheSubnetGroupName = cacheSubnetGroupName;
        }

        public final Collection<CacheNode> getCacheNodes() {
            return this.cacheNodes;
        }

        @Override
        public final Builder cacheNodes(Collection<CacheNode> cacheNodes) {
            this.cacheNodes = CacheNodeListCopier.copy(cacheNodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheNodes(CacheNode ... cacheNodes) {
            if (this.cacheNodes == null) {
                this.cacheNodes = new SdkInternalList(cacheNodes.length);
            }
            for (CacheNode e : cacheNodes) {
                this.cacheNodes.add(e);
            }
            return this;
        }

        public final void setCacheNodes(Collection<CacheNode> cacheNodes) {
            this.cacheNodes = CacheNodeListCopier.copy(cacheNodes);
        }

        @SafeVarargs
        public final void setCacheNodes(CacheNode ... cacheNodes) {
            if (this.cacheNodes == null) {
                this.cacheNodes = new SdkInternalList(cacheNodes.length);
            }
            for (CacheNode e : cacheNodes) {
                this.cacheNodes.add(e);
            }
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        public final Collection<SecurityGroupMembership> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<SecurityGroupMembership> securityGroups) {
            this.securityGroups = SecurityGroupMembershipListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(SecurityGroupMembership ... securityGroups) {
            if (this.securityGroups == null) {
                this.securityGroups = new SdkInternalList(securityGroups.length);
            }
            for (SecurityGroupMembership e : securityGroups) {
                this.securityGroups.add(e);
            }
            return this;
        }

        public final void setSecurityGroups(Collection<SecurityGroupMembership> securityGroups) {
            this.securityGroups = SecurityGroupMembershipListCopier.copy(securityGroups);
        }

        @SafeVarargs
        public final void setSecurityGroups(SecurityGroupMembership ... securityGroups) {
            if (this.securityGroups == null) {
                this.securityGroups = new SdkInternalList(securityGroups.length);
            }
            for (SecurityGroupMembership e : securityGroups) {
                this.securityGroups.add(e);
            }
        }

        public final String getReplicationGroupId() {
            return this.replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        public final Integer getSnapshotRetentionLimit() {
            return this.snapshotRetentionLimit;
        }

        @Override
        public final Builder snapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
            return this;
        }

        public final void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
        }

        public final String getSnapshotWindow() {
            return this.snapshotWindow;
        }

        @Override
        public final Builder snapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
            return this;
        }

        public final void setSnapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
        }

        public CacheCluster build() {
            return new CacheCluster(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CacheCluster> {
        public Builder cacheClusterId(String var1);

        public Builder configurationEndpoint(Endpoint var1);

        public Builder clientDownloadLandingPage(String var1);

        public Builder cacheNodeType(String var1);

        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder cacheClusterStatus(String var1);

        public Builder numCacheNodes(Integer var1);

        public Builder preferredAvailabilityZone(String var1);

        public Builder cacheClusterCreateTime(Date var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder pendingModifiedValues(PendingModifiedValues var1);

        public Builder notificationConfiguration(NotificationConfiguration var1);

        public Builder cacheSecurityGroups(Collection<CacheSecurityGroupMembership> var1);

        public Builder cacheSecurityGroups(CacheSecurityGroupMembership ... var1);

        public Builder cacheParameterGroup(CacheParameterGroupStatus var1);

        public Builder cacheSubnetGroupName(String var1);

        public Builder cacheNodes(Collection<CacheNode> var1);

        public Builder cacheNodes(CacheNode ... var1);

        public Builder autoMinorVersionUpgrade(Boolean var1);

        public Builder securityGroups(Collection<SecurityGroupMembership> var1);

        public Builder securityGroups(SecurityGroupMembership ... var1);

        public Builder replicationGroupId(String var1);

        public Builder snapshotRetentionLimit(Integer var1);

        public Builder snapshotWindow(String var1);
    }
}

