/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.eks.model.AddonPodIdentityAssociations;
import software.amazon.awssdk.services.eks.model.AddonPodIdentityAssociationsListCopier;
import software.amazon.awssdk.services.eks.model.EksRequest;
import software.amazon.awssdk.services.eks.model.ResolveConflicts;
import software.amazon.awssdk.services.eks.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAddonRequest
extends EksRequest
implements ToCopyableBuilder<Builder, CreateAddonRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterName").getter(CreateAddonRequest.getter(CreateAddonRequest::clusterName)).setter(CreateAddonRequest.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()}).build();
    private static final SdkField<String> ADDON_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("addonName").getter(CreateAddonRequest.getter(CreateAddonRequest::addonName)).setter(CreateAddonRequest.setter(Builder::addonName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addonName").build()}).build();
    private static final SdkField<String> ADDON_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("addonVersion").getter(CreateAddonRequest.getter(CreateAddonRequest::addonVersion)).setter(CreateAddonRequest.setter(Builder::addonVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addonVersion").build()}).build();
    private static final SdkField<String> SERVICE_ACCOUNT_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceAccountRoleArn").getter(CreateAddonRequest.getter(CreateAddonRequest::serviceAccountRoleArn)).setter(CreateAddonRequest.setter(Builder::serviceAccountRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceAccountRoleArn").build()}).build();
    private static final SdkField<String> RESOLVE_CONFLICTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resolveConflicts").getter(CreateAddonRequest.getter(CreateAddonRequest::resolveConflictsAsString)).setter(CreateAddonRequest.setter(Builder::resolveConflicts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolveConflicts").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(CreateAddonRequest.getter(CreateAddonRequest::clientRequestToken)).setter(CreateAddonRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateAddonRequest.getter(CreateAddonRequest::tags)).setter(CreateAddonRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CONFIGURATION_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configurationValues").getter(CreateAddonRequest.getter(CreateAddonRequest::configurationValues)).setter(CreateAddonRequest.setter(Builder::configurationValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationValues").build()}).build();
    private static final SdkField<List<AddonPodIdentityAssociations>> POD_IDENTITY_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("podIdentityAssociations").getter(CreateAddonRequest.getter(CreateAddonRequest::podIdentityAssociations)).setter(CreateAddonRequest.setter(Builder::podIdentityAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("podIdentityAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AddonPodIdentityAssociations::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD, ADDON_NAME_FIELD, ADDON_VERSION_FIELD, SERVICE_ACCOUNT_ROLE_ARN_FIELD, RESOLVE_CONFLICTS_FIELD, CLIENT_REQUEST_TOKEN_FIELD, TAGS_FIELD, CONFIGURATION_VALUES_FIELD, POD_IDENTITY_ASSOCIATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateAddonRequest.memberNameToFieldInitializer();
    private final String clusterName;
    private final String addonName;
    private final String addonVersion;
    private final String serviceAccountRoleArn;
    private final String resolveConflicts;
    private final String clientRequestToken;
    private final Map<String, String> tags;
    private final String configurationValues;
    private final List<AddonPodIdentityAssociations> podIdentityAssociations;

    private CreateAddonRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.addonName = builder.addonName;
        this.addonVersion = builder.addonVersion;
        this.serviceAccountRoleArn = builder.serviceAccountRoleArn;
        this.resolveConflicts = builder.resolveConflicts;
        this.clientRequestToken = builder.clientRequestToken;
        this.tags = builder.tags;
        this.configurationValues = builder.configurationValues;
        this.podIdentityAssociations = builder.podIdentityAssociations;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final String addonName() {
        return this.addonName;
    }

    public final String addonVersion() {
        return this.addonVersion;
    }

    public final String serviceAccountRoleArn() {
        return this.serviceAccountRoleArn;
    }

    public final ResolveConflicts resolveConflicts() {
        return ResolveConflicts.fromValue(this.resolveConflicts);
    }

    public final String resolveConflictsAsString() {
        return this.resolveConflicts;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String configurationValues() {
        return this.configurationValues;
    }

    public final boolean hasPodIdentityAssociations() {
        return this.podIdentityAssociations != null && !(this.podIdentityAssociations instanceof SdkAutoConstructList);
    }

    public final List<AddonPodIdentityAssociations> podIdentityAssociations() {
        return this.podIdentityAssociations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.addonName());
        hashCode = 31 * hashCode + Objects.hashCode(this.addonVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAccountRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolveConflictsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPodIdentityAssociations() ? this.podIdentityAssociations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAddonRequest)) {
            return false;
        }
        CreateAddonRequest other = (CreateAddonRequest)((Object)obj);
        return Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.addonName(), other.addonName()) && Objects.equals(this.addonVersion(), other.addonVersion()) && Objects.equals(this.serviceAccountRoleArn(), other.serviceAccountRoleArn()) && Objects.equals(this.resolveConflictsAsString(), other.resolveConflictsAsString()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.configurationValues(), other.configurationValues()) && this.hasPodIdentityAssociations() == other.hasPodIdentityAssociations() && Objects.equals(this.podIdentityAssociations(), other.podIdentityAssociations());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAddonRequest").add("ClusterName", (Object)this.clusterName()).add("AddonName", (Object)this.addonName()).add("AddonVersion", (Object)this.addonVersion()).add("ServiceAccountRoleArn", (Object)this.serviceAccountRoleArn()).add("ResolveConflicts", (Object)this.resolveConflictsAsString()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("Tags", this.hasTags() ? this.tags() : null).add("ConfigurationValues", (Object)this.configurationValues()).add("PodIdentityAssociations", this.hasPodIdentityAssociations() ? this.podIdentityAssociations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "addonName": {
                return Optional.ofNullable(clazz.cast(this.addonName()));
            }
            case "addonVersion": {
                return Optional.ofNullable(clazz.cast(this.addonVersion()));
            }
            case "serviceAccountRoleArn": {
                return Optional.ofNullable(clazz.cast(this.serviceAccountRoleArn()));
            }
            case "resolveConflicts": {
                return Optional.ofNullable(clazz.cast(this.resolveConflictsAsString()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "configurationValues": {
                return Optional.ofNullable(clazz.cast(this.configurationValues()));
            }
            case "podIdentityAssociations": {
                return Optional.ofNullable(clazz.cast(this.podIdentityAssociations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", CLUSTER_NAME_FIELD);
        map.put("addonName", ADDON_NAME_FIELD);
        map.put("addonVersion", ADDON_VERSION_FIELD);
        map.put("serviceAccountRoleArn", SERVICE_ACCOUNT_ROLE_ARN_FIELD);
        map.put("resolveConflicts", RESOLVE_CONFLICTS_FIELD);
        map.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("configurationValues", CONFIGURATION_VALUES_FIELD);
        map.put("podIdentityAssociations", POD_IDENTITY_ASSOCIATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAddonRequest, T> g) {
        return obj -> g.apply((CreateAddonRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EksRequest.BuilderImpl
    implements Builder {
        private String clusterName;
        private String addonName;
        private String addonVersion;
        private String serviceAccountRoleArn;
        private String resolveConflicts;
        private String clientRequestToken;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String configurationValues;
        private List<AddonPodIdentityAssociations> podIdentityAssociations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAddonRequest model) {
            super(model);
            this.clusterName(model.clusterName);
            this.addonName(model.addonName);
            this.addonVersion(model.addonVersion);
            this.serviceAccountRoleArn(model.serviceAccountRoleArn);
            this.resolveConflicts(model.resolveConflicts);
            this.clientRequestToken(model.clientRequestToken);
            this.tags(model.tags);
            this.configurationValues(model.configurationValues);
            this.podIdentityAssociations(model.podIdentityAssociations);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getAddonName() {
            return this.addonName;
        }

        public final void setAddonName(String addonName) {
            this.addonName = addonName;
        }

        @Override
        public final Builder addonName(String addonName) {
            this.addonName = addonName;
            return this;
        }

        public final String getAddonVersion() {
            return this.addonVersion;
        }

        public final void setAddonVersion(String addonVersion) {
            this.addonVersion = addonVersion;
        }

        @Override
        public final Builder addonVersion(String addonVersion) {
            this.addonVersion = addonVersion;
            return this;
        }

        public final String getServiceAccountRoleArn() {
            return this.serviceAccountRoleArn;
        }

        public final void setServiceAccountRoleArn(String serviceAccountRoleArn) {
            this.serviceAccountRoleArn = serviceAccountRoleArn;
        }

        @Override
        public final Builder serviceAccountRoleArn(String serviceAccountRoleArn) {
            this.serviceAccountRoleArn = serviceAccountRoleArn;
            return this;
        }

        public final String getResolveConflicts() {
            return this.resolveConflicts;
        }

        public final void setResolveConflicts(String resolveConflicts) {
            this.resolveConflicts = resolveConflicts;
        }

        @Override
        public final Builder resolveConflicts(String resolveConflicts) {
            this.resolveConflicts = resolveConflicts;
            return this;
        }

        @Override
        public final Builder resolveConflicts(ResolveConflicts resolveConflicts) {
            this.resolveConflicts(resolveConflicts == null ? null : resolveConflicts.toString());
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getConfigurationValues() {
            return this.configurationValues;
        }

        public final void setConfigurationValues(String configurationValues) {
            this.configurationValues = configurationValues;
        }

        @Override
        public final Builder configurationValues(String configurationValues) {
            this.configurationValues = configurationValues;
            return this;
        }

        public final List<AddonPodIdentityAssociations.Builder> getPodIdentityAssociations() {
            List<AddonPodIdentityAssociations.Builder> result = AddonPodIdentityAssociationsListCopier.copyToBuilder(this.podIdentityAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPodIdentityAssociations(Collection<AddonPodIdentityAssociations.BuilderImpl> podIdentityAssociations) {
            this.podIdentityAssociations = AddonPodIdentityAssociationsListCopier.copyFromBuilder(podIdentityAssociations);
        }

        @Override
        public final Builder podIdentityAssociations(Collection<AddonPodIdentityAssociations> podIdentityAssociations) {
            this.podIdentityAssociations = AddonPodIdentityAssociationsListCopier.copy(podIdentityAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder podIdentityAssociations(AddonPodIdentityAssociations ... podIdentityAssociations) {
            this.podIdentityAssociations(Arrays.asList(podIdentityAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder podIdentityAssociations(Consumer<AddonPodIdentityAssociations.Builder> ... podIdentityAssociations) {
            this.podIdentityAssociations(Stream.of(podIdentityAssociations).map(c -> (AddonPodIdentityAssociations)((AddonPodIdentityAssociations.Builder)AddonPodIdentityAssociations.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAddonRequest build() {
            return new CreateAddonRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAddonRequest> {
        public Builder clusterName(String var1);

        public Builder addonName(String var1);

        public Builder addonVersion(String var1);

        public Builder serviceAccountRoleArn(String var1);

        public Builder resolveConflicts(String var1);

        public Builder resolveConflicts(ResolveConflicts var1);

        public Builder clientRequestToken(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder configurationValues(String var1);

        public Builder podIdentityAssociations(Collection<AddonPodIdentityAssociations> var1);

        public Builder podIdentityAssociations(AddonPodIdentityAssociations ... var1);

        public Builder podIdentityAssociations(Consumer<AddonPodIdentityAssociations.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

