/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.eks.model.AMITypes;
import software.amazon.awssdk.services.eks.model.CapacityTypes;
import software.amazon.awssdk.services.eks.model.EksRequest;
import software.amazon.awssdk.services.eks.model.LaunchTemplateSpecification;
import software.amazon.awssdk.services.eks.model.NodeRepairConfig;
import software.amazon.awssdk.services.eks.model.NodegroupScalingConfig;
import software.amazon.awssdk.services.eks.model.NodegroupUpdateConfig;
import software.amazon.awssdk.services.eks.model.RemoteAccessConfig;
import software.amazon.awssdk.services.eks.model.StringListCopier;
import software.amazon.awssdk.services.eks.model.TagMapCopier;
import software.amazon.awssdk.services.eks.model.Taint;
import software.amazon.awssdk.services.eks.model._labelsMapCopier;
import software.amazon.awssdk.services.eks.model._taintsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateNodegroupRequest
extends EksRequest
implements ToCopyableBuilder<Builder, CreateNodegroupRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterName").getter(CreateNodegroupRequest.getter(CreateNodegroupRequest::clusterName)).setter(CreateNodegroupRequest.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()}).build();
    private static final SdkField<String> NODEGROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nodegroupName").getter(CreateNodegroupRequest.getter(CreateNodegroupRequest::nodegroupName)).setter(CreateNodegroupRequest.setter(Builder::nodegroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodegroupName").build()}).build();
    private static final SdkField<NodegroupScalingConfig> SCALING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scalingConfig").getter(CreateNodegroupRequest.getter(CreateNodegroupRequest::scalingConfig)).setter(CreateNodegroupRequest.setter(Builder::scalingConfig)).constructor(NodegroupScalingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalingConfig").build()}).build();
    private static final SdkField<Integer> DISK_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("diskSize").getter(CreateNodegroupRequest.getter(CreateNodegroupRequest::diskSize)).setter(CreateNodegroupRequest.setter(Builder::diskSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diskSize").build()}).build();
    private static final SdkField<List<String>> SUBNETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("subnets").getter(CreateNodegroupRequest.getter(CreateNodegroupRequest::subnets)).setter(CreateNodegroupRequest.setter(Builder::subnets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INSTANCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("instanceTypes").getter(CreateNodegroupRequest.getter(CreateNodegroupRequest::instanceTypes)).setter(CreateNodegroupRequest.setter(Builder::instanceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AMI_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("amiType").getter(CreateNodegroupRequest.getter(CreateNodegroupRequest::amiTypeAsString)).setter(CreateNodegroupRequest.setter(Builder::amiType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amiType").build()}).build();
    private static final SdkField<RemoteAccessConfig> REMOTE_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("remoteAccess").getter(CreateNodegroupRequest.getter(CreateNodegroupRequest::remoteAccess)).setter(CreateNodegroupRequest.setter(Builder::remoteAccess)).constructor(RemoteAccessConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteAccess").build()}).build();
    private static final SdkField<String> NODE_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nodeRole").getter(CreateNodegroupRequest.getter(CreateNodegroupRequest::nodeRole)).setter(CreateNodegroupRequest.setter(Builder::nodeRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeRole").build()}).build();
    private static final SdkField<Map<String, String>> LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("labels").getter(CreateNodegroupRequest.getter(CreateNodegroupRequest::labels)).setter(CreateNodegroupRequest.setter(Builder::labels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labels").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<Taint>> TAINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("taints").getter(CreateNodegroupRequest.getter(CreateNodegroupRequest::taints)).setter(CreateNodegroupRequest.setter(Builder::taints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Taint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateNodegroupRequest.getter(CreateNodegroupRequest::tags)).setter(CreateNodegroupRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(CreateNodegroupRequest.getter(CreateNodegroupRequest::clientRequestToken)).setter(CreateNodegroupRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<LaunchTemplateSpecification> LAUNCH_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("launchTemplate").getter(CreateNodegroupRequest.getter(CreateNodegroupRequest::launchTemplate)).setter(CreateNodegroupRequest.setter(Builder::launchTemplate)).constructor(LaunchTemplateSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchTemplate").build()}).build();
    private static final SdkField<NodegroupUpdateConfig> UPDATE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("updateConfig").getter(CreateNodegroupRequest.getter(CreateNodegroupRequest::updateConfig)).setter(CreateNodegroupRequest.setter(Builder::updateConfig)).constructor(NodegroupUpdateConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateConfig").build()}).build();
    private static final SdkField<NodeRepairConfig> NODE_REPAIR_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("nodeRepairConfig").getter(CreateNodegroupRequest.getter(CreateNodegroupRequest::nodeRepairConfig)).setter(CreateNodegroupRequest.setter(Builder::nodeRepairConfig)).constructor(NodeRepairConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeRepairConfig").build()}).build();
    private static final SdkField<String> CAPACITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("capacityType").getter(CreateNodegroupRequest.getter(CreateNodegroupRequest::capacityTypeAsString)).setter(CreateNodegroupRequest.setter(Builder::capacityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityType").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(CreateNodegroupRequest.getter(CreateNodegroupRequest::version)).setter(CreateNodegroupRequest.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<String> RELEASE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("releaseVersion").getter(CreateNodegroupRequest.getter(CreateNodegroupRequest::releaseVersion)).setter(CreateNodegroupRequest.setter(Builder::releaseVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("releaseVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD, NODEGROUP_NAME_FIELD, SCALING_CONFIG_FIELD, DISK_SIZE_FIELD, SUBNETS_FIELD, INSTANCE_TYPES_FIELD, AMI_TYPE_FIELD, REMOTE_ACCESS_FIELD, NODE_ROLE_FIELD, LABELS_FIELD, TAINTS_FIELD, TAGS_FIELD, CLIENT_REQUEST_TOKEN_FIELD, LAUNCH_TEMPLATE_FIELD, UPDATE_CONFIG_FIELD, NODE_REPAIR_CONFIG_FIELD, CAPACITY_TYPE_FIELD, VERSION_FIELD, RELEASE_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateNodegroupRequest.memberNameToFieldInitializer();
    private final String clusterName;
    private final String nodegroupName;
    private final NodegroupScalingConfig scalingConfig;
    private final Integer diskSize;
    private final List<String> subnets;
    private final List<String> instanceTypes;
    private final String amiType;
    private final RemoteAccessConfig remoteAccess;
    private final String nodeRole;
    private final Map<String, String> labels;
    private final List<Taint> taints;
    private final Map<String, String> tags;
    private final String clientRequestToken;
    private final LaunchTemplateSpecification launchTemplate;
    private final NodegroupUpdateConfig updateConfig;
    private final NodeRepairConfig nodeRepairConfig;
    private final String capacityType;
    private final String version;
    private final String releaseVersion;

    private CreateNodegroupRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.nodegroupName = builder.nodegroupName;
        this.scalingConfig = builder.scalingConfig;
        this.diskSize = builder.diskSize;
        this.subnets = builder.subnets;
        this.instanceTypes = builder.instanceTypes;
        this.amiType = builder.amiType;
        this.remoteAccess = builder.remoteAccess;
        this.nodeRole = builder.nodeRole;
        this.labels = builder.labels;
        this.taints = builder.taints;
        this.tags = builder.tags;
        this.clientRequestToken = builder.clientRequestToken;
        this.launchTemplate = builder.launchTemplate;
        this.updateConfig = builder.updateConfig;
        this.nodeRepairConfig = builder.nodeRepairConfig;
        this.capacityType = builder.capacityType;
        this.version = builder.version;
        this.releaseVersion = builder.releaseVersion;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final String nodegroupName() {
        return this.nodegroupName;
    }

    public final NodegroupScalingConfig scalingConfig() {
        return this.scalingConfig;
    }

    public final Integer diskSize() {
        return this.diskSize;
    }

    public final boolean hasSubnets() {
        return this.subnets != null && !(this.subnets instanceof SdkAutoConstructList);
    }

    public final List<String> subnets() {
        return this.subnets;
    }

    public final boolean hasInstanceTypes() {
        return this.instanceTypes != null && !(this.instanceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> instanceTypes() {
        return this.instanceTypes;
    }

    public final AMITypes amiType() {
        return AMITypes.fromValue(this.amiType);
    }

    public final String amiTypeAsString() {
        return this.amiType;
    }

    public final RemoteAccessConfig remoteAccess() {
        return this.remoteAccess;
    }

    public final String nodeRole() {
        return this.nodeRole;
    }

    public final boolean hasLabels() {
        return this.labels != null && !(this.labels instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> labels() {
        return this.labels;
    }

    public final boolean hasTaints() {
        return this.taints != null && !(this.taints instanceof SdkAutoConstructList);
    }

    public final List<Taint> taints() {
        return this.taints;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final LaunchTemplateSpecification launchTemplate() {
        return this.launchTemplate;
    }

    public final NodegroupUpdateConfig updateConfig() {
        return this.updateConfig;
    }

    public final NodeRepairConfig nodeRepairConfig() {
        return this.nodeRepairConfig;
    }

    public final CapacityTypes capacityType() {
        return CapacityTypes.fromValue(this.capacityType);
    }

    public final String capacityTypeAsString() {
        return this.capacityType;
    }

    public final String version() {
        return this.version;
    }

    public final String releaseVersion() {
        return this.releaseVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodegroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.diskSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnets() ? this.subnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceTypes() ? this.instanceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.amiTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteAccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLabels() ? this.labels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTaints() ? this.taints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeRepairConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.releaseVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNodegroupRequest)) {
            return false;
        }
        CreateNodegroupRequest other = (CreateNodegroupRequest)((Object)obj);
        return Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.nodegroupName(), other.nodegroupName()) && Objects.equals(this.scalingConfig(), other.scalingConfig()) && Objects.equals(this.diskSize(), other.diskSize()) && this.hasSubnets() == other.hasSubnets() && Objects.equals(this.subnets(), other.subnets()) && this.hasInstanceTypes() == other.hasInstanceTypes() && Objects.equals(this.instanceTypes(), other.instanceTypes()) && Objects.equals(this.amiTypeAsString(), other.amiTypeAsString()) && Objects.equals(this.remoteAccess(), other.remoteAccess()) && Objects.equals(this.nodeRole(), other.nodeRole()) && this.hasLabels() == other.hasLabels() && Objects.equals(this.labels(), other.labels()) && this.hasTaints() == other.hasTaints() && Objects.equals(this.taints(), other.taints()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.launchTemplate(), other.launchTemplate()) && Objects.equals(this.updateConfig(), other.updateConfig()) && Objects.equals(this.nodeRepairConfig(), other.nodeRepairConfig()) && Objects.equals(this.capacityTypeAsString(), other.capacityTypeAsString()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.releaseVersion(), other.releaseVersion());
    }

    public final String toString() {
        return ToString.builder((String)"CreateNodegroupRequest").add("ClusterName", (Object)this.clusterName()).add("NodegroupName", (Object)this.nodegroupName()).add("ScalingConfig", (Object)this.scalingConfig()).add("DiskSize", (Object)this.diskSize()).add("Subnets", this.hasSubnets() ? this.subnets() : null).add("InstanceTypes", this.hasInstanceTypes() ? this.instanceTypes() : null).add("AmiType", (Object)this.amiTypeAsString()).add("RemoteAccess", (Object)this.remoteAccess()).add("NodeRole", (Object)this.nodeRole()).add("Labels", this.hasLabels() ? this.labels() : null).add("Taints", this.hasTaints() ? this.taints() : null).add("Tags", this.hasTags() ? this.tags() : null).add("ClientRequestToken", (Object)this.clientRequestToken()).add("LaunchTemplate", (Object)this.launchTemplate()).add("UpdateConfig", (Object)this.updateConfig()).add("NodeRepairConfig", (Object)this.nodeRepairConfig()).add("CapacityType", (Object)this.capacityTypeAsString()).add("Version", (Object)this.version()).add("ReleaseVersion", (Object)this.releaseVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "nodegroupName": {
                return Optional.ofNullable(clazz.cast(this.nodegroupName()));
            }
            case "scalingConfig": {
                return Optional.ofNullable(clazz.cast(this.scalingConfig()));
            }
            case "diskSize": {
                return Optional.ofNullable(clazz.cast(this.diskSize()));
            }
            case "subnets": {
                return Optional.ofNullable(clazz.cast(this.subnets()));
            }
            case "instanceTypes": {
                return Optional.ofNullable(clazz.cast(this.instanceTypes()));
            }
            case "amiType": {
                return Optional.ofNullable(clazz.cast(this.amiTypeAsString()));
            }
            case "remoteAccess": {
                return Optional.ofNullable(clazz.cast(this.remoteAccess()));
            }
            case "nodeRole": {
                return Optional.ofNullable(clazz.cast(this.nodeRole()));
            }
            case "labels": {
                return Optional.ofNullable(clazz.cast(this.labels()));
            }
            case "taints": {
                return Optional.ofNullable(clazz.cast(this.taints()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "launchTemplate": {
                return Optional.ofNullable(clazz.cast(this.launchTemplate()));
            }
            case "updateConfig": {
                return Optional.ofNullable(clazz.cast(this.updateConfig()));
            }
            case "nodeRepairConfig": {
                return Optional.ofNullable(clazz.cast(this.nodeRepairConfig()));
            }
            case "capacityType": {
                return Optional.ofNullable(clazz.cast(this.capacityTypeAsString()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "releaseVersion": {
                return Optional.ofNullable(clazz.cast(this.releaseVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", CLUSTER_NAME_FIELD);
        map.put("nodegroupName", NODEGROUP_NAME_FIELD);
        map.put("scalingConfig", SCALING_CONFIG_FIELD);
        map.put("diskSize", DISK_SIZE_FIELD);
        map.put("subnets", SUBNETS_FIELD);
        map.put("instanceTypes", INSTANCE_TYPES_FIELD);
        map.put("amiType", AMI_TYPE_FIELD);
        map.put("remoteAccess", REMOTE_ACCESS_FIELD);
        map.put("nodeRole", NODE_ROLE_FIELD);
        map.put("labels", LABELS_FIELD);
        map.put("taints", TAINTS_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("launchTemplate", LAUNCH_TEMPLATE_FIELD);
        map.put("updateConfig", UPDATE_CONFIG_FIELD);
        map.put("nodeRepairConfig", NODE_REPAIR_CONFIG_FIELD);
        map.put("capacityType", CAPACITY_TYPE_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("releaseVersion", RELEASE_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateNodegroupRequest, T> g) {
        return obj -> g.apply((CreateNodegroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EksRequest.BuilderImpl
    implements Builder {
        private String clusterName;
        private String nodegroupName;
        private NodegroupScalingConfig scalingConfig;
        private Integer diskSize;
        private List<String> subnets = DefaultSdkAutoConstructList.getInstance();
        private List<String> instanceTypes = DefaultSdkAutoConstructList.getInstance();
        private String amiType;
        private RemoteAccessConfig remoteAccess;
        private String nodeRole;
        private Map<String, String> labels = DefaultSdkAutoConstructMap.getInstance();
        private List<Taint> taints = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String clientRequestToken;
        private LaunchTemplateSpecification launchTemplate;
        private NodegroupUpdateConfig updateConfig;
        private NodeRepairConfig nodeRepairConfig;
        private String capacityType;
        private String version;
        private String releaseVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNodegroupRequest model) {
            super(model);
            this.clusterName(model.clusterName);
            this.nodegroupName(model.nodegroupName);
            this.scalingConfig(model.scalingConfig);
            this.diskSize(model.diskSize);
            this.subnets(model.subnets);
            this.instanceTypes(model.instanceTypes);
            this.amiType(model.amiType);
            this.remoteAccess(model.remoteAccess);
            this.nodeRole(model.nodeRole);
            this.labels(model.labels);
            this.taints(model.taints);
            this.tags(model.tags);
            this.clientRequestToken(model.clientRequestToken);
            this.launchTemplate(model.launchTemplate);
            this.updateConfig(model.updateConfig);
            this.nodeRepairConfig(model.nodeRepairConfig);
            this.capacityType(model.capacityType);
            this.version(model.version);
            this.releaseVersion(model.releaseVersion);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getNodegroupName() {
            return this.nodegroupName;
        }

        public final void setNodegroupName(String nodegroupName) {
            this.nodegroupName = nodegroupName;
        }

        @Override
        public final Builder nodegroupName(String nodegroupName) {
            this.nodegroupName = nodegroupName;
            return this;
        }

        public final NodegroupScalingConfig.Builder getScalingConfig() {
            return this.scalingConfig != null ? this.scalingConfig.toBuilder() : null;
        }

        public final void setScalingConfig(NodegroupScalingConfig.BuilderImpl scalingConfig) {
            this.scalingConfig = scalingConfig != null ? scalingConfig.build() : null;
        }

        @Override
        public final Builder scalingConfig(NodegroupScalingConfig scalingConfig) {
            this.scalingConfig = scalingConfig;
            return this;
        }

        public final Integer getDiskSize() {
            return this.diskSize;
        }

        public final void setDiskSize(Integer diskSize) {
            this.diskSize = diskSize;
        }

        @Override
        public final Builder diskSize(Integer diskSize) {
            this.diskSize = diskSize;
            return this;
        }

        public final Collection<String> getSubnets() {
            if (this.subnets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnets;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String ... subnets) {
            this.subnets(Arrays.asList(subnets));
            return this;
        }

        public final Collection<String> getInstanceTypes() {
            if (this.instanceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.instanceTypes;
        }

        public final void setInstanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = StringListCopier.copy(instanceTypes);
        }

        @Override
        public final Builder instanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = StringListCopier.copy(instanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypes(String ... instanceTypes) {
            this.instanceTypes(Arrays.asList(instanceTypes));
            return this;
        }

        public final String getAmiType() {
            return this.amiType;
        }

        public final void setAmiType(String amiType) {
            this.amiType = amiType;
        }

        @Override
        public final Builder amiType(String amiType) {
            this.amiType = amiType;
            return this;
        }

        @Override
        public final Builder amiType(AMITypes amiType) {
            this.amiType(amiType == null ? null : amiType.toString());
            return this;
        }

        public final RemoteAccessConfig.Builder getRemoteAccess() {
            return this.remoteAccess != null ? this.remoteAccess.toBuilder() : null;
        }

        public final void setRemoteAccess(RemoteAccessConfig.BuilderImpl remoteAccess) {
            this.remoteAccess = remoteAccess != null ? remoteAccess.build() : null;
        }

        @Override
        public final Builder remoteAccess(RemoteAccessConfig remoteAccess) {
            this.remoteAccess = remoteAccess;
            return this;
        }

        public final String getNodeRole() {
            return this.nodeRole;
        }

        public final void setNodeRole(String nodeRole) {
            this.nodeRole = nodeRole;
        }

        @Override
        public final Builder nodeRole(String nodeRole) {
            this.nodeRole = nodeRole;
            return this;
        }

        public final Map<String, String> getLabels() {
            if (this.labels instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.labels;
        }

        public final void setLabels(Map<String, String> labels) {
            this.labels = _labelsMapCopier.copy(labels);
        }

        @Override
        public final Builder labels(Map<String, String> labels) {
            this.labels = _labelsMapCopier.copy(labels);
            return this;
        }

        public final List<Taint.Builder> getTaints() {
            List<Taint.Builder> result = _taintsListCopier.copyToBuilder(this.taints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTaints(Collection<Taint.BuilderImpl> taints) {
            this.taints = _taintsListCopier.copyFromBuilder(taints);
        }

        @Override
        public final Builder taints(Collection<Taint> taints) {
            this.taints = _taintsListCopier.copy(taints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taints(Taint ... taints) {
            this.taints(Arrays.asList(taints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taints(Consumer<Taint.Builder> ... taints) {
            this.taints(Stream.of(taints).map(c -> (Taint)((Taint.Builder)Taint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final LaunchTemplateSpecification.Builder getLaunchTemplate() {
            return this.launchTemplate != null ? this.launchTemplate.toBuilder() : null;
        }

        public final void setLaunchTemplate(LaunchTemplateSpecification.BuilderImpl launchTemplate) {
            this.launchTemplate = launchTemplate != null ? launchTemplate.build() : null;
        }

        @Override
        public final Builder launchTemplate(LaunchTemplateSpecification launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        public final NodegroupUpdateConfig.Builder getUpdateConfig() {
            return this.updateConfig != null ? this.updateConfig.toBuilder() : null;
        }

        public final void setUpdateConfig(NodegroupUpdateConfig.BuilderImpl updateConfig) {
            this.updateConfig = updateConfig != null ? updateConfig.build() : null;
        }

        @Override
        public final Builder updateConfig(NodegroupUpdateConfig updateConfig) {
            this.updateConfig = updateConfig;
            return this;
        }

        public final NodeRepairConfig.Builder getNodeRepairConfig() {
            return this.nodeRepairConfig != null ? this.nodeRepairConfig.toBuilder() : null;
        }

        public final void setNodeRepairConfig(NodeRepairConfig.BuilderImpl nodeRepairConfig) {
            this.nodeRepairConfig = nodeRepairConfig != null ? nodeRepairConfig.build() : null;
        }

        @Override
        public final Builder nodeRepairConfig(NodeRepairConfig nodeRepairConfig) {
            this.nodeRepairConfig = nodeRepairConfig;
            return this;
        }

        public final String getCapacityType() {
            return this.capacityType;
        }

        public final void setCapacityType(String capacityType) {
            this.capacityType = capacityType;
        }

        @Override
        public final Builder capacityType(String capacityType) {
            this.capacityType = capacityType;
            return this;
        }

        @Override
        public final Builder capacityType(CapacityTypes capacityType) {
            this.capacityType(capacityType == null ? null : capacityType.toString());
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getReleaseVersion() {
            return this.releaseVersion;
        }

        public final void setReleaseVersion(String releaseVersion) {
            this.releaseVersion = releaseVersion;
        }

        @Override
        public final Builder releaseVersion(String releaseVersion) {
            this.releaseVersion = releaseVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateNodegroupRequest build() {
            return new CreateNodegroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateNodegroupRequest> {
        public Builder clusterName(String var1);

        public Builder nodegroupName(String var1);

        public Builder scalingConfig(NodegroupScalingConfig var1);

        default public Builder scalingConfig(Consumer<NodegroupScalingConfig.Builder> scalingConfig) {
            return this.scalingConfig((NodegroupScalingConfig)((NodegroupScalingConfig.Builder)NodegroupScalingConfig.builder().applyMutation(scalingConfig)).build());
        }

        public Builder diskSize(Integer var1);

        public Builder subnets(Collection<String> var1);

        public Builder subnets(String ... var1);

        public Builder instanceTypes(Collection<String> var1);

        public Builder instanceTypes(String ... var1);

        public Builder amiType(String var1);

        public Builder amiType(AMITypes var1);

        public Builder remoteAccess(RemoteAccessConfig var1);

        default public Builder remoteAccess(Consumer<RemoteAccessConfig.Builder> remoteAccess) {
            return this.remoteAccess((RemoteAccessConfig)((RemoteAccessConfig.Builder)RemoteAccessConfig.builder().applyMutation(remoteAccess)).build());
        }

        public Builder nodeRole(String var1);

        public Builder labels(Map<String, String> var1);

        public Builder taints(Collection<Taint> var1);

        public Builder taints(Taint ... var1);

        public Builder taints(Consumer<Taint.Builder> ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder clientRequestToken(String var1);

        public Builder launchTemplate(LaunchTemplateSpecification var1);

        default public Builder launchTemplate(Consumer<LaunchTemplateSpecification.Builder> launchTemplate) {
            return this.launchTemplate((LaunchTemplateSpecification)((LaunchTemplateSpecification.Builder)LaunchTemplateSpecification.builder().applyMutation(launchTemplate)).build());
        }

        public Builder updateConfig(NodegroupUpdateConfig var1);

        default public Builder updateConfig(Consumer<NodegroupUpdateConfig.Builder> updateConfig) {
            return this.updateConfig((NodegroupUpdateConfig)((NodegroupUpdateConfig.Builder)NodegroupUpdateConfig.builder().applyMutation(updateConfig)).build());
        }

        public Builder nodeRepairConfig(NodeRepairConfig var1);

        default public Builder nodeRepairConfig(Consumer<NodeRepairConfig.Builder> nodeRepairConfig) {
            return this.nodeRepairConfig((NodeRepairConfig)((NodeRepairConfig.Builder)NodeRepairConfig.builder().applyMutation(nodeRepairConfig)).build());
        }

        public Builder capacityType(String var1);

        public Builder capacityType(CapacityTypes var1);

        public Builder version(String var1);

        public Builder releaseVersion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

