/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.eks.model.AddonCompatibilityDetail;
import software.amazon.awssdk.services.eks.model.AddonCompatibilityDetailsCopier;
import software.amazon.awssdk.services.eks.model.DeprecationDetail;
import software.amazon.awssdk.services.eks.model.DeprecationDetailsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InsightCategorySpecificSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InsightCategorySpecificSummary> {
    private static final SdkField<List<DeprecationDetail>> DEPRECATION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("deprecationDetails").getter(InsightCategorySpecificSummary.getter(InsightCategorySpecificSummary::deprecationDetails)).setter(InsightCategorySpecificSummary.setter(Builder::deprecationDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deprecationDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeprecationDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AddonCompatibilityDetail>> ADDON_COMPATIBILITY_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("addonCompatibilityDetails").getter(InsightCategorySpecificSummary.getter(InsightCategorySpecificSummary::addonCompatibilityDetails)).setter(InsightCategorySpecificSummary.setter(Builder::addonCompatibilityDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addonCompatibilityDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AddonCompatibilityDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPRECATION_DETAILS_FIELD, ADDON_COMPATIBILITY_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InsightCategorySpecificSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<DeprecationDetail> deprecationDetails;
    private final List<AddonCompatibilityDetail> addonCompatibilityDetails;

    private InsightCategorySpecificSummary(BuilderImpl builder) {
        this.deprecationDetails = builder.deprecationDetails;
        this.addonCompatibilityDetails = builder.addonCompatibilityDetails;
    }

    public final boolean hasDeprecationDetails() {
        return this.deprecationDetails != null && !(this.deprecationDetails instanceof SdkAutoConstructList);
    }

    public final List<DeprecationDetail> deprecationDetails() {
        return this.deprecationDetails;
    }

    public final boolean hasAddonCompatibilityDetails() {
        return this.addonCompatibilityDetails != null && !(this.addonCompatibilityDetails instanceof SdkAutoConstructList);
    }

    public final List<AddonCompatibilityDetail> addonCompatibilityDetails() {
        return this.addonCompatibilityDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeprecationDetails() ? this.deprecationDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddonCompatibilityDetails() ? this.addonCompatibilityDetails() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InsightCategorySpecificSummary)) {
            return false;
        }
        InsightCategorySpecificSummary other = (InsightCategorySpecificSummary)obj;
        return this.hasDeprecationDetails() == other.hasDeprecationDetails() && Objects.equals(this.deprecationDetails(), other.deprecationDetails()) && this.hasAddonCompatibilityDetails() == other.hasAddonCompatibilityDetails() && Objects.equals(this.addonCompatibilityDetails(), other.addonCompatibilityDetails());
    }

    public final String toString() {
        return ToString.builder((String)"InsightCategorySpecificSummary").add("DeprecationDetails", this.hasDeprecationDetails() ? this.deprecationDetails() : null).add("AddonCompatibilityDetails", this.hasAddonCompatibilityDetails() ? this.addonCompatibilityDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deprecationDetails": {
                return Optional.ofNullable(clazz.cast(this.deprecationDetails()));
            }
            case "addonCompatibilityDetails": {
                return Optional.ofNullable(clazz.cast(this.addonCompatibilityDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("deprecationDetails", DEPRECATION_DETAILS_FIELD);
        map.put("addonCompatibilityDetails", ADDON_COMPATIBILITY_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InsightCategorySpecificSummary, T> g) {
        return obj -> g.apply((InsightCategorySpecificSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<DeprecationDetail> deprecationDetails = DefaultSdkAutoConstructList.getInstance();
        private List<AddonCompatibilityDetail> addonCompatibilityDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InsightCategorySpecificSummary model) {
            this.deprecationDetails(model.deprecationDetails);
            this.addonCompatibilityDetails(model.addonCompatibilityDetails);
        }

        public final List<DeprecationDetail.Builder> getDeprecationDetails() {
            List<DeprecationDetail.Builder> result = DeprecationDetailsCopier.copyToBuilder(this.deprecationDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeprecationDetails(Collection<DeprecationDetail.BuilderImpl> deprecationDetails) {
            this.deprecationDetails = DeprecationDetailsCopier.copyFromBuilder(deprecationDetails);
        }

        @Override
        public final Builder deprecationDetails(Collection<DeprecationDetail> deprecationDetails) {
            this.deprecationDetails = DeprecationDetailsCopier.copy(deprecationDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deprecationDetails(DeprecationDetail ... deprecationDetails) {
            this.deprecationDetails(Arrays.asList(deprecationDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deprecationDetails(Consumer<DeprecationDetail.Builder> ... deprecationDetails) {
            this.deprecationDetails(Stream.of(deprecationDetails).map(c -> (DeprecationDetail)((DeprecationDetail.Builder)DeprecationDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AddonCompatibilityDetail.Builder> getAddonCompatibilityDetails() {
            List<AddonCompatibilityDetail.Builder> result = AddonCompatibilityDetailsCopier.copyToBuilder(this.addonCompatibilityDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddonCompatibilityDetails(Collection<AddonCompatibilityDetail.BuilderImpl> addonCompatibilityDetails) {
            this.addonCompatibilityDetails = AddonCompatibilityDetailsCopier.copyFromBuilder(addonCompatibilityDetails);
        }

        @Override
        public final Builder addonCompatibilityDetails(Collection<AddonCompatibilityDetail> addonCompatibilityDetails) {
            this.addonCompatibilityDetails = AddonCompatibilityDetailsCopier.copy(addonCompatibilityDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addonCompatibilityDetails(AddonCompatibilityDetail ... addonCompatibilityDetails) {
            this.addonCompatibilityDetails(Arrays.asList(addonCompatibilityDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addonCompatibilityDetails(Consumer<AddonCompatibilityDetail.Builder> ... addonCompatibilityDetails) {
            this.addonCompatibilityDetails(Stream.of(addonCompatibilityDetails).map(c -> (AddonCompatibilityDetail)((AddonCompatibilityDetail.Builder)AddonCompatibilityDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public InsightCategorySpecificSummary build() {
            return new InsightCategorySpecificSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InsightCategorySpecificSummary> {
        public Builder deprecationDetails(Collection<DeprecationDetail> var1);

        public Builder deprecationDetails(DeprecationDetail ... var1);

        public Builder deprecationDetails(Consumer<DeprecationDetail.Builder> ... var1);

        public Builder addonCompatibilityDetails(Collection<AddonCompatibilityDetail> var1);

        public Builder addonCompatibilityDetails(AddonCompatibilityDetail ... var1);

        public Builder addonCompatibilityDetails(Consumer<AddonCompatibilityDetail.Builder> ... var1);
    }
}

