/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.eks.EksClient;
import software.amazon.awssdk.services.eks.internal.UserAgentUtils;
import software.amazon.awssdk.services.eks.model.ListAccessEntriesRequest;
import software.amazon.awssdk.services.eks.model.ListAccessEntriesResponse;

public class ListAccessEntriesIterable
implements SdkIterable<ListAccessEntriesResponse> {
    private final EksClient client;
    private final ListAccessEntriesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAccessEntriesIterable(EksClient client, ListAccessEntriesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAccessEntriesResponseFetcher();
    }

    public Iterator<ListAccessEntriesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> accessEntries() {
        Function<ListAccessEntriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.accessEntries() != null) {
                return response.accessEntries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAccessEntriesResponseFetcher
    implements SyncPageFetcher<ListAccessEntriesResponse> {
        private ListAccessEntriesResponseFetcher() {
        }

        public boolean hasNextPage(ListAccessEntriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAccessEntriesResponse nextPage(ListAccessEntriesResponse previousPage) {
            if (previousPage == null) {
                return ListAccessEntriesIterable.this.client.listAccessEntries(ListAccessEntriesIterable.this.firstRequest);
            }
            return ListAccessEntriesIterable.this.client.listAccessEntries((ListAccessEntriesRequest)((Object)ListAccessEntriesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

