/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.eks.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComputeConfigRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComputeConfigRequest> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enabled").getter(ComputeConfigRequest.getter(ComputeConfigRequest::enabled)).setter(ComputeConfigRequest.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()}).build();
    private static final SdkField<List<String>> NODE_POOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("nodePools").getter(ComputeConfigRequest.getter(ComputeConfigRequest::nodePools)).setter(ComputeConfigRequest.setter(Builder::nodePools)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodePools").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NODE_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nodeRoleArn").getter(ComputeConfigRequest.getter(ComputeConfigRequest::nodeRoleArn)).setter(ComputeConfigRequest.setter(Builder::nodeRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, NODE_POOLS_FIELD, NODE_ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("enabled", ENABLED_FIELD);
            this.put("nodePools", NODE_POOLS_FIELD);
            this.put("nodeRoleArn", NODE_ROLE_ARN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final List<String> nodePools;
    private final String nodeRoleArn;

    private ComputeConfigRequest(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.nodePools = builder.nodePools;
        this.nodeRoleArn = builder.nodeRoleArn;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final boolean hasNodePools() {
        return this.nodePools != null && !(this.nodePools instanceof SdkAutoConstructList);
    }

    public final List<String> nodePools() {
        return this.nodePools;
    }

    public final String nodeRoleArn() {
        return this.nodeRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNodePools() ? this.nodePools() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeConfigRequest)) {
            return false;
        }
        ComputeConfigRequest other = (ComputeConfigRequest)obj;
        return Objects.equals(this.enabled(), other.enabled()) && this.hasNodePools() == other.hasNodePools() && Objects.equals(this.nodePools(), other.nodePools()) && Objects.equals(this.nodeRoleArn(), other.nodeRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"ComputeConfigRequest").add("Enabled", (Object)this.enabled()).add("NodePools", this.hasNodePools() ? this.nodePools() : null).add("NodeRoleArn", (Object)this.nodeRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "nodePools": {
                return Optional.ofNullable(clazz.cast(this.nodePools()));
            }
            case "nodeRoleArn": {
                return Optional.ofNullable(clazz.cast(this.nodeRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ComputeConfigRequest, T> g) {
        return obj -> g.apply((ComputeConfigRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private List<String> nodePools = DefaultSdkAutoConstructList.getInstance();
        private String nodeRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeConfigRequest model) {
            this.enabled(model.enabled);
            this.nodePools(model.nodePools);
            this.nodeRoleArn(model.nodeRoleArn);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Collection<String> getNodePools() {
            if (this.nodePools instanceof SdkAutoConstructList) {
                return null;
            }
            return this.nodePools;
        }

        public final void setNodePools(Collection<String> nodePools) {
            this.nodePools = StringListCopier.copy(nodePools);
        }

        @Override
        public final Builder nodePools(Collection<String> nodePools) {
            this.nodePools = StringListCopier.copy(nodePools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodePools(String ... nodePools) {
            this.nodePools(Arrays.asList(nodePools));
            return this;
        }

        public final String getNodeRoleArn() {
            return this.nodeRoleArn;
        }

        public final void setNodeRoleArn(String nodeRoleArn) {
            this.nodeRoleArn = nodeRoleArn;
        }

        @Override
        public final Builder nodeRoleArn(String nodeRoleArn) {
            this.nodeRoleArn = nodeRoleArn;
            return this;
        }

        public ComputeConfigRequest build() {
            return new ComputeConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComputeConfigRequest> {
        public Builder enabled(Boolean var1);

        public Builder nodePools(Collection<String> var1);

        public Builder nodePools(String ... var1);

        public Builder nodeRoleArn(String var1);
    }
}

