/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.eks.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PodIdentityAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PodIdentityAssociation> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterName").getter(PodIdentityAssociation.getter(PodIdentityAssociation::clusterName)).setter(PodIdentityAssociation.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespace").getter(PodIdentityAssociation.getter(PodIdentityAssociation::namespace)).setter(PodIdentityAssociation.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()}).build();
    private static final SdkField<String> SERVICE_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceAccount").getter(PodIdentityAssociation.getter(PodIdentityAssociation::serviceAccount)).setter(PodIdentityAssociation.setter(Builder::serviceAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceAccount").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(PodIdentityAssociation.getter(PodIdentityAssociation::roleArn)).setter(PodIdentityAssociation.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> ASSOCIATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("associationArn").getter(PodIdentityAssociation.getter(PodIdentityAssociation::associationArn)).setter(PodIdentityAssociation.setter(Builder::associationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationArn").build()}).build();
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("associationId").getter(PodIdentityAssociation.getter(PodIdentityAssociation::associationId)).setter(PodIdentityAssociation.setter(Builder::associationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationId").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(PodIdentityAssociation.getter(PodIdentityAssociation::tags)).setter(PodIdentityAssociation.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(PodIdentityAssociation.getter(PodIdentityAssociation::createdAt)).setter(PodIdentityAssociation.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("modifiedAt").getter(PodIdentityAssociation.getter(PodIdentityAssociation::modifiedAt)).setter(PodIdentityAssociation.setter(Builder::modifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD, NAMESPACE_FIELD, SERVICE_ACCOUNT_FIELD, ROLE_ARN_FIELD, ASSOCIATION_ARN_FIELD, ASSOCIATION_ID_FIELD, TAGS_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String clusterName;
    private final String namespace;
    private final String serviceAccount;
    private final String roleArn;
    private final String associationArn;
    private final String associationId;
    private final Map<String, String> tags;
    private final Instant createdAt;
    private final Instant modifiedAt;

    private PodIdentityAssociation(BuilderImpl builder) {
        this.clusterName = builder.clusterName;
        this.namespace = builder.namespace;
        this.serviceAccount = builder.serviceAccount;
        this.roleArn = builder.roleArn;
        this.associationArn = builder.associationArn;
        this.associationId = builder.associationId;
        this.tags = builder.tags;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final String serviceAccount() {
        return this.serviceAccount;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String associationArn() {
        return this.associationArn;
    }

    public final String associationId() {
        return this.associationId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant modifiedAt() {
        return this.modifiedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PodIdentityAssociation)) {
            return false;
        }
        PodIdentityAssociation other = (PodIdentityAssociation)obj;
        return Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.serviceAccount(), other.serviceAccount()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.associationArn(), other.associationArn()) && Objects.equals(this.associationId(), other.associationId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.modifiedAt(), other.modifiedAt());
    }

    public final String toString() {
        return ToString.builder((String)"PodIdentityAssociation").add("ClusterName", (Object)this.clusterName()).add("Namespace", (Object)this.namespace()).add("ServiceAccount", (Object)this.serviceAccount()).add("RoleArn", (Object)this.roleArn()).add("AssociationArn", (Object)this.associationArn()).add("AssociationId", (Object)this.associationId()).add("Tags", this.hasTags() ? this.tags() : null).add("CreatedAt", (Object)this.createdAt()).add("ModifiedAt", (Object)this.modifiedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "serviceAccount": {
                return Optional.ofNullable(clazz.cast(this.serviceAccount()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "associationArn": {
                return Optional.ofNullable(clazz.cast(this.associationArn()));
            }
            case "associationId": {
                return Optional.ofNullable(clazz.cast(this.associationId()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "modifiedAt": {
                return Optional.ofNullable(clazz.cast(this.modifiedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PodIdentityAssociation, T> g) {
        return obj -> g.apply((PodIdentityAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterName;
        private String namespace;
        private String serviceAccount;
        private String roleArn;
        private String associationArn;
        private String associationId;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Instant createdAt;
        private Instant modifiedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(PodIdentityAssociation model) {
            this.clusterName(model.clusterName);
            this.namespace(model.namespace);
            this.serviceAccount(model.serviceAccount);
            this.roleArn(model.roleArn);
            this.associationArn(model.associationArn);
            this.associationId(model.associationId);
            this.tags(model.tags);
            this.createdAt(model.createdAt);
            this.modifiedAt(model.modifiedAt);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getServiceAccount() {
            return this.serviceAccount;
        }

        public final void setServiceAccount(String serviceAccount) {
            this.serviceAccount = serviceAccount;
        }

        @Override
        public final Builder serviceAccount(String serviceAccount) {
            this.serviceAccount = serviceAccount;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getAssociationArn() {
            return this.associationArn;
        }

        public final void setAssociationArn(String associationArn) {
            this.associationArn = associationArn;
        }

        @Override
        public final Builder associationArn(String associationArn) {
            this.associationArn = associationArn;
            return this;
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return this.modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public PodIdentityAssociation build() {
            return new PodIdentityAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PodIdentityAssociation> {
        public Builder clusterName(String var1);

        public Builder namespace(String var1);

        public Builder serviceAccount(String var1);

        public Builder roleArn(String var1);

        public Builder associationArn(String var1);

        public Builder associationId(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder createdAt(Instant var1);

        public Builder modifiedAt(Instant var1);
    }
}

