/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ClusterIssueCode {
    ACCESS_DENIED("AccessDenied"),
    CLUSTER_UNREACHABLE("ClusterUnreachable"),
    CONFIGURATION_CONFLICT("ConfigurationConflict"),
    INTERNAL_FAILURE("InternalFailure"),
    RESOURCE_LIMIT_EXCEEDED("ResourceLimitExceeded"),
    RESOURCE_NOT_FOUND("ResourceNotFound"),
    IAM_ROLE_NOT_FOUND("IamRoleNotFound"),
    VPC_NOT_FOUND("VpcNotFound"),
    INSUFFICIENT_FREE_ADDRESSES("InsufficientFreeAddresses"),
    EC2_SERVICE_NOT_SUBSCRIBED("Ec2ServiceNotSubscribed"),
    EC2_SUBNET_NOT_FOUND("Ec2SubnetNotFound"),
    EC2_SECURITY_GROUP_NOT_FOUND("Ec2SecurityGroupNotFound"),
    KMS_GRANT_REVOKED("KmsGrantRevoked"),
    KMS_KEY_NOT_FOUND("KmsKeyNotFound"),
    KMS_KEY_MARKED_FOR_DELETION("KmsKeyMarkedForDeletion"),
    KMS_KEY_DISABLED("KmsKeyDisabled"),
    STS_REGIONAL_ENDPOINT_DISABLED("StsRegionalEndpointDisabled"),
    UNSUPPORTED_VERSION("UnsupportedVersion"),
    OTHER("Other"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ClusterIssueCode> VALUE_MAP;
    private final String value;

    private ClusterIssueCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ClusterIssueCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ClusterIssueCode> knownValues() {
        EnumSet<ClusterIssueCode> knownValues = EnumSet.allOf(ClusterIssueCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ClusterIssueCode.class, ClusterIssueCode::toString);
    }
}

