/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.eks.DefaultEksAsyncClient;
import software.amazon.awssdk.services.eks.DefaultEksBaseClientBuilder;
import software.amazon.awssdk.services.eks.EksAsyncClient;
import software.amazon.awssdk.services.eks.EksAsyncClientBuilder;
import software.amazon.awssdk.services.eks.EksServiceClientConfiguration;
import software.amazon.awssdk.services.eks.endpoints.EksEndpointProvider;

@SdkInternalApi
final class DefaultEksAsyncClientBuilder
extends DefaultEksBaseClientBuilder<EksAsyncClientBuilder, EksAsyncClient>
implements EksAsyncClientBuilder {
    DefaultEksAsyncClientBuilder() {
    }

    @Override
    public DefaultEksAsyncClientBuilder endpointProvider(EksEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final EksAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultEksAsyncClientBuilder.validateClientOptions(clientConfiguration);
        EksServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultEksAsyncClient client = new DefaultEksAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private EksServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return EksServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

