/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The health of the add-on.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddonHealth implements SdkPojo, Serializable, ToCopyableBuilder<AddonHealth.Builder, AddonHealth> {
    private static final SdkField<List<AddonIssue>> ISSUES_FIELD = SdkField
            .<List<AddonIssue>> builder(MarshallingType.LIST)
            .memberName("issues")
            .getter(getter(AddonHealth::issues))
            .setter(setter(Builder::issues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AddonIssue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AddonIssue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ISSUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AddonIssue> issues;

    private AddonHealth(BuilderImpl builder) {
        this.issues = builder.issues;
    }

    /**
     * Returns true if the Issues property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasIssues() {
        return issues != null && !(issues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An object that represents the add-on's health issues.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIssues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An object that represents the add-on's health issues.
     */
    public final List<AddonIssue> issues() {
        return issues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasIssues() ? issues() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddonHealth)) {
            return false;
        }
        AddonHealth other = (AddonHealth) obj;
        return hasIssues() == other.hasIssues() && Objects.equals(issues(), other.issues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddonHealth").add("Issues", hasIssues() ? issues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "issues":
            return Optional.ofNullable(clazz.cast(issues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddonHealth, T> g) {
        return obj -> g.apply((AddonHealth) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AddonHealth> {
        /**
         * <p>
         * An object that represents the add-on's health issues.
         * </p>
         * 
         * @param issues
         *        An object that represents the add-on's health issues.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issues(Collection<AddonIssue> issues);

        /**
         * <p>
         * An object that represents the add-on's health issues.
         * </p>
         * 
         * @param issues
         *        An object that represents the add-on's health issues.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issues(AddonIssue... issues);

        /**
         * <p>
         * An object that represents the add-on's health issues.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AddonIssue>.Builder} avoiding the need to
         * create one manually via {@link List<AddonIssue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AddonIssue>.Builder#build()} is called immediately and its
         * result is passed to {@link #issues(List<AddonIssue>)}.
         * 
         * @param issues
         *        a consumer that will call methods on {@link List<AddonIssue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #issues(List<AddonIssue>)
         */
        Builder issues(Consumer<AddonIssue.Builder>... issues);
    }

    static final class BuilderImpl implements Builder {
        private List<AddonIssue> issues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddonHealth model) {
            issues(model.issues);
        }

        public final Collection<AddonIssue.Builder> getIssues() {
            if (issues instanceof SdkAutoConstructList) {
                return null;
            }
            return issues != null ? issues.stream().map(AddonIssue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder issues(Collection<AddonIssue> issues) {
            this.issues = AddonIssueListCopier.copy(issues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder issues(AddonIssue... issues) {
            issues(Arrays.asList(issues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder issues(Consumer<AddonIssue.Builder>... issues) {
            issues(Stream.of(issues).map(c -> AddonIssue.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIssues(Collection<AddonIssue.BuilderImpl> issues) {
            this.issues = AddonIssueListCopier.copyFromBuilder(issues);
        }

        @Override
        public AddonHealth build() {
            return new AddonHealth(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
