/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateNodegroupVersionRequest extends EksRequest implements
        ToCopyableBuilder<UpdateNodegroupVersionRequest.Builder, UpdateNodegroupVersionRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateNodegroupVersionRequest::clusterName)).setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<String> NODEGROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateNodegroupVersionRequest::nodegroupName)).setter(setter(Builder::nodegroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("nodegroupName").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateNodegroupVersionRequest::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<String> RELEASE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateNodegroupVersionRequest::releaseVersion)).setter(setter(Builder::releaseVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("releaseVersion").build()).build();

    private static final SdkField<Boolean> FORCE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpdateNodegroupVersionRequest::force)).setter(setter(Builder::force))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("force").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateNodegroupVersionRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD,
            NODEGROUP_NAME_FIELD, VERSION_FIELD, RELEASE_VERSION_FIELD, FORCE_FIELD, CLIENT_REQUEST_TOKEN_FIELD));

    private final String clusterName;

    private final String nodegroupName;

    private final String version;

    private final String releaseVersion;

    private final Boolean force;

    private final String clientRequestToken;

    private UpdateNodegroupVersionRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.nodegroupName = builder.nodegroupName;
        this.version = builder.version;
        this.releaseVersion = builder.releaseVersion;
        this.force = builder.force;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The name of the Amazon EKS cluster that is associated with the managed node group to update.
     * </p>
     * 
     * @return The name of the Amazon EKS cluster that is associated with the managed node group to update.
     */
    public String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The name of the managed node group to update.
     * </p>
     * 
     * @return The name of the managed node group to update.
     */
    public String nodegroupName() {
        return nodegroupName;
    }

    /**
     * <p>
     * The Kubernetes version to update to. If no version is specified, then the Kubernetes version of the node group
     * does not change. You can specify the Kubernetes version of the cluster to update the node group to the latest AMI
     * version of the cluster's Kubernetes version.
     * </p>
     * 
     * @return The Kubernetes version to update to. If no version is specified, then the Kubernetes version of the node
     *         group does not change. You can specify the Kubernetes version of the cluster to update the node group to
     *         the latest AMI version of the cluster's Kubernetes version.
     */
    public String version() {
        return version;
    }

    /**
     * <p>
     * The AMI version of the Amazon EKS-optimized AMI to use for the update. By default, the latest available AMI
     * version for the node group's Kubernetes version is used. For more information, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html">Amazon EKS-Optimized Linux
     * AMI Versions </a> in the <i>Amazon EKS User Guide</i>.
     * </p>
     * 
     * @return The AMI version of the Amazon EKS-optimized AMI to use for the update. By default, the latest available
     *         AMI version for the node group's Kubernetes version is used. For more information, see <a
     *         href="https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html">Amazon EKS-Optimized
     *         Linux AMI Versions </a> in the <i>Amazon EKS User Guide</i>.
     */
    public String releaseVersion() {
        return releaseVersion;
    }

    /**
     * <p>
     * Force the update if the existing node group's pods are unable to be drained due to a pod disruption budget issue.
     * If an update fails because pods could not be drained, you can force the update after it fails to terminate the
     * old node whether or not any pods are running on the node.
     * </p>
     * 
     * @return Force the update if the existing node group's pods are unable to be drained due to a pod disruption
     *         budget issue. If an update fails because pods could not be drained, you can force the update after it
     *         fails to terminate the old node whether or not any pods are running on the node.
     */
    public Boolean force() {
        return force;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(nodegroupName());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(releaseVersion());
        hashCode = 31 * hashCode + Objects.hashCode(force());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateNodegroupVersionRequest)) {
            return false;
        }
        UpdateNodegroupVersionRequest other = (UpdateNodegroupVersionRequest) obj;
        return Objects.equals(clusterName(), other.clusterName()) && Objects.equals(nodegroupName(), other.nodegroupName())
                && Objects.equals(version(), other.version()) && Objects.equals(releaseVersion(), other.releaseVersion())
                && Objects.equals(force(), other.force()) && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateNodegroupVersionRequest").add("ClusterName", clusterName())
                .add("NodegroupName", nodegroupName()).add("Version", version()).add("ReleaseVersion", releaseVersion())
                .add("Force", force()).add("ClientRequestToken", clientRequestToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "nodegroupName":
            return Optional.ofNullable(clazz.cast(nodegroupName()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "releaseVersion":
            return Optional.ofNullable(clazz.cast(releaseVersion()));
        case "force":
            return Optional.ofNullable(clazz.cast(force()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateNodegroupVersionRequest, T> g) {
        return obj -> g.apply((UpdateNodegroupVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EksRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateNodegroupVersionRequest> {
        /**
         * <p>
         * The name of the Amazon EKS cluster that is associated with the managed node group to update.
         * </p>
         * 
         * @param clusterName
         *        The name of the Amazon EKS cluster that is associated with the managed node group to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The name of the managed node group to update.
         * </p>
         * 
         * @param nodegroupName
         *        The name of the managed node group to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodegroupName(String nodegroupName);

        /**
         * <p>
         * The Kubernetes version to update to. If no version is specified, then the Kubernetes version of the node
         * group does not change. You can specify the Kubernetes version of the cluster to update the node group to the
         * latest AMI version of the cluster's Kubernetes version.
         * </p>
         * 
         * @param version
         *        The Kubernetes version to update to. If no version is specified, then the Kubernetes version of the
         *        node group does not change. You can specify the Kubernetes version of the cluster to update the node
         *        group to the latest AMI version of the cluster's Kubernetes version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The AMI version of the Amazon EKS-optimized AMI to use for the update. By default, the latest available AMI
         * version for the node group's Kubernetes version is used. For more information, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html">Amazon EKS-Optimized
         * Linux AMI Versions </a> in the <i>Amazon EKS User Guide</i>.
         * </p>
         * 
         * @param releaseVersion
         *        The AMI version of the Amazon EKS-optimized AMI to use for the update. By default, the latest
         *        available AMI version for the node group's Kubernetes version is used. For more information, see <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html">Amazon
         *        EKS-Optimized Linux AMI Versions </a> in the <i>Amazon EKS User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder releaseVersion(String releaseVersion);

        /**
         * <p>
         * Force the update if the existing node group's pods are unable to be drained due to a pod disruption budget
         * issue. If an update fails because pods could not be drained, you can force the update after it fails to
         * terminate the old node whether or not any pods are running on the node.
         * </p>
         * 
         * @param force
         *        Force the update if the existing node group's pods are unable to be drained due to a pod disruption
         *        budget issue. If an update fails because pods could not be drained, you can force the update after it
         *        fails to terminate the old node whether or not any pods are running on the node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder force(Boolean force);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientRequestToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EksRequest.BuilderImpl implements Builder {
        private String clusterName;

        private String nodegroupName;

        private String version;

        private String releaseVersion;

        private Boolean force;

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateNodegroupVersionRequest model) {
            super(model);
            clusterName(model.clusterName);
            nodegroupName(model.nodegroupName);
            version(model.version);
            releaseVersion(model.releaseVersion);
            force(model.force);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getClusterName() {
            return clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        public final String getNodegroupName() {
            return nodegroupName;
        }

        @Override
        public final Builder nodegroupName(String nodegroupName) {
            this.nodegroupName = nodegroupName;
            return this;
        }

        public final void setNodegroupName(String nodegroupName) {
            this.nodegroupName = nodegroupName;
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getReleaseVersion() {
            return releaseVersion;
        }

        @Override
        public final Builder releaseVersion(String releaseVersion) {
            this.releaseVersion = releaseVersion;
            return this;
        }

        public final void setReleaseVersion(String releaseVersion) {
            this.releaseVersion = releaseVersion;
        }

        public final Boolean getForce() {
            return force;
        }

        @Override
        public final Builder force(Boolean force) {
            this.force = force;
            return this;
        }

        public final void setForce(Boolean force) {
            this.force = force;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateNodegroupVersionRequest build() {
            return new UpdateNodegroupVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
