/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the <a href="https://openid.net/connect/">OpenID Connect</a> identity provider information for
 * the cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OIDC implements SdkPojo, Serializable, ToCopyableBuilder<OIDC.Builder, OIDC> {
    private static final SdkField<String> ISSUER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OIDC::issuer)).setter(setter(Builder::issuer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issuer").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ISSUER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String issuer;

    private OIDC(BuilderImpl builder) {
        this.issuer = builder.issuer;
    }

    /**
     * <p>
     * The issuer URL for the OpenID Connect identity provider.
     * </p>
     * 
     * @return The issuer URL for the OpenID Connect identity provider.
     */
    public String issuer() {
        return issuer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(issuer());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OIDC)) {
            return false;
        }
        OIDC other = (OIDC) obj;
        return Objects.equals(issuer(), other.issuer());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("OIDC").add("Issuer", issuer()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "issuer":
            return Optional.ofNullable(clazz.cast(issuer()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OIDC, T> g) {
        return obj -> g.apply((OIDC) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OIDC> {
        /**
         * <p>
         * The issuer URL for the OpenID Connect identity provider.
         * </p>
         * 
         * @param issuer
         *        The issuer URL for the OpenID Connect identity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuer(String issuer);
    }

    static final class BuilderImpl implements Builder {
        private String issuer;

        private BuilderImpl() {
        }

        private BuilderImpl(OIDC model) {
            issuer(model.issuer);
        }

        public final String getIssuer() {
            return issuer;
        }

        @Override
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        @Override
        public OIDC build() {
            return new OIDC(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
