/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateClusterRequest extends EksRequest implements
        ToCopyableBuilder<CreateClusterRequest.Builder, CreateClusterRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateClusterRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateClusterRequest::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateClusterRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<VpcConfigRequest> RESOURCES_VPC_CONFIG_FIELD = SdkField
            .<VpcConfigRequest> builder(MarshallingType.SDK_POJO).getter(getter(CreateClusterRequest::resourcesVpcConfig))
            .setter(setter(Builder::resourcesVpcConfig)).constructor(VpcConfigRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourcesVpcConfig").build())
            .build();

    private static final SdkField<Logging> LOGGING_FIELD = SdkField.<Logging> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateClusterRequest::logging)).setter(setter(Builder::logging)).constructor(Logging::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logging").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateClusterRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(CreateClusterRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<EncryptionConfig>> ENCRYPTION_CONFIG_FIELD = SdkField
            .<List<EncryptionConfig>> builder(MarshallingType.LIST)
            .getter(getter(CreateClusterRequest::encryptionConfig))
            .setter(setter(Builder::encryptionConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionConfig").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EncryptionConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(EncryptionConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VERSION_FIELD,
            ROLE_ARN_FIELD, RESOURCES_VPC_CONFIG_FIELD, LOGGING_FIELD, CLIENT_REQUEST_TOKEN_FIELD, TAGS_FIELD,
            ENCRYPTION_CONFIG_FIELD));

    private final String name;

    private final String version;

    private final String roleArn;

    private final VpcConfigRequest resourcesVpcConfig;

    private final Logging logging;

    private final String clientRequestToken;

    private final Map<String, String> tags;

    private final List<EncryptionConfig> encryptionConfig;

    private CreateClusterRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.version = builder.version;
        this.roleArn = builder.roleArn;
        this.resourcesVpcConfig = builder.resourcesVpcConfig;
        this.logging = builder.logging;
        this.clientRequestToken = builder.clientRequestToken;
        this.tags = builder.tags;
        this.encryptionConfig = builder.encryptionConfig;
    }

    /**
     * <p>
     * The unique name to give to your cluster.
     * </p>
     * 
     * @return The unique name to give to your cluster.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The desired Kubernetes version for your cluster. If you don't specify a value here, the latest version available
     * in Amazon EKS is used.
     * </p>
     * 
     * @return The desired Kubernetes version for your cluster. If you don't specify a value here, the latest version
     *         available in Amazon EKS is used.
     */
    public String version() {
        return version;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that provides permissions for Amazon EKS to make calls to other
     * AWS API operations on your behalf. For more information, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/service_IAM_role.html">Amazon EKS Service IAM Role</a> in
     * the <i> <i>Amazon EKS User Guide</i> </i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that provides permissions for Amazon EKS to make calls to
     *         other AWS API operations on your behalf. For more information, see <a
     *         href="https://docs.aws.amazon.com/eks/latest/userguide/service_IAM_role.html">Amazon EKS Service IAM
     *         Role</a> in the <i> <i>Amazon EKS User Guide</i> </i>.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The VPC configuration used by the cluster control plane. Amazon EKS VPC resources have specific requirements to
     * work properly with Kubernetes. For more information, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html">Cluster VPC Considerations</a> and <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html">Cluster Security Group
     * Considerations</a> in the <i>Amazon EKS User Guide</i>. You must specify at least two subnets. You can specify up
     * to five security groups, but we recommend that you use a dedicated security group for your cluster control plane.
     * </p>
     * 
     * @return The VPC configuration used by the cluster control plane. Amazon EKS VPC resources have specific
     *         requirements to work properly with Kubernetes. For more information, see <a
     *         href="https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html">Cluster VPC Considerations</a>
     *         and <a href="https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html">Cluster Security Group
     *         Considerations</a> in the <i>Amazon EKS User Guide</i>. You must specify at least two subnets. You can
     *         specify up to five security groups, but we recommend that you use a dedicated security group for your
     *         cluster control plane.
     */
    public VpcConfigRequest resourcesVpcConfig() {
        return resourcesVpcConfig;
    }

    /**
     * <p>
     * Enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs. By default,
     * cluster control plane logs aren't exported to CloudWatch Logs. For more information, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html">Amazon EKS Cluster Control Plane
     * Logs</a> in the <i> <i>Amazon EKS User Guide</i> </i>.
     * </p>
     * <note>
     * <p>
     * CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs. For
     * more information, see <a href="http://aws.amazon.com/cloudwatch/pricing/">Amazon CloudWatch Pricing</a>.
     * </p>
     * </note>
     * 
     * @return Enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs. By
     *         default, cluster control plane logs aren't exported to CloudWatch Logs. For more information, see <a
     *         href="https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html">Amazon EKS Cluster
     *         Control Plane Logs</a> in the <i> <i>Amazon EKS User Guide</i> </i>.</p> <note>
     *         <p>
     *         CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs.
     *         For more information, see <a href="http://aws.amazon.com/cloudwatch/pricing/">Amazon CloudWatch
     *         Pricing</a>.
     *         </p>
     */
    public Logging logging() {
        return logging;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The metadata to apply to the cluster to assist with categorization and organization. Each tag consists of a key
     * and an optional value, both of which you define.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The metadata to apply to the cluster to assist with categorization and organization. Each tag consists of
     *         a key and an optional value, both of which you define.
     */
    public Map<String, String> tags() {
        return tags;
    }

    /**
     * Returns true if the EncryptionConfig property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasEncryptionConfig() {
        return encryptionConfig != null && !(encryptionConfig instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The encryption configuration for the cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEncryptionConfig()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The encryption configuration for the cluster.
     */
    public List<EncryptionConfig> encryptionConfig() {
        return encryptionConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourcesVpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(logging());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClusterRequest)) {
            return false;
        }
        CreateClusterRequest other = (CreateClusterRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(version(), other.version())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(resourcesVpcConfig(), other.resourcesVpcConfig())
                && Objects.equals(logging(), other.logging()) && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(tags(), other.tags()) && Objects.equals(encryptionConfig(), other.encryptionConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateClusterRequest").add("Name", name()).add("Version", version()).add("RoleArn", roleArn())
                .add("ResourcesVpcConfig", resourcesVpcConfig()).add("Logging", logging())
                .add("ClientRequestToken", clientRequestToken()).add("Tags", tags()).add("EncryptionConfig", encryptionConfig())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "resourcesVpcConfig":
            return Optional.ofNullable(clazz.cast(resourcesVpcConfig()));
        case "logging":
            return Optional.ofNullable(clazz.cast(logging()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "encryptionConfig":
            return Optional.ofNullable(clazz.cast(encryptionConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateClusterRequest, T> g) {
        return obj -> g.apply((CreateClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EksRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateClusterRequest> {
        /**
         * <p>
         * The unique name to give to your cluster.
         * </p>
         * 
         * @param name
         *        The unique name to give to your cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The desired Kubernetes version for your cluster. If you don't specify a value here, the latest version
         * available in Amazon EKS is used.
         * </p>
         * 
         * @param version
         *        The desired Kubernetes version for your cluster. If you don't specify a value here, the latest version
         *        available in Amazon EKS is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that provides permissions for Amazon EKS to make calls to
         * other AWS API operations on your behalf. For more information, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/service_IAM_role.html">Amazon EKS Service IAM Role</a>
         * in the <i> <i>Amazon EKS User Guide</i> </i>.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role that provides permissions for Amazon EKS to make calls
         *        to other AWS API operations on your behalf. For more information, see <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/service_IAM_role.html">Amazon EKS Service IAM
         *        Role</a> in the <i> <i>Amazon EKS User Guide</i> </i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The VPC configuration used by the cluster control plane. Amazon EKS VPC resources have specific requirements
         * to work properly with Kubernetes. For more information, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html">Cluster VPC Considerations</a> and
         * <a href="https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html">Cluster Security Group
         * Considerations</a> in the <i>Amazon EKS User Guide</i>. You must specify at least two subnets. You can
         * specify up to five security groups, but we recommend that you use a dedicated security group for your cluster
         * control plane.
         * </p>
         * 
         * @param resourcesVpcConfig
         *        The VPC configuration used by the cluster control plane. Amazon EKS VPC resources have specific
         *        requirements to work properly with Kubernetes. For more information, see <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html">Cluster VPC
         *        Considerations</a> and <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html">Cluster Security Group
         *        Considerations</a> in the <i>Amazon EKS User Guide</i>. You must specify at least two subnets. You can
         *        specify up to five security groups, but we recommend that you use a dedicated security group for your
         *        cluster control plane.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcesVpcConfig(VpcConfigRequest resourcesVpcConfig);

        /**
         * <p>
         * The VPC configuration used by the cluster control plane. Amazon EKS VPC resources have specific requirements
         * to work properly with Kubernetes. For more information, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html">Cluster VPC Considerations</a> and
         * <a href="https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html">Cluster Security Group
         * Considerations</a> in the <i>Amazon EKS User Guide</i>. You must specify at least two subnets. You can
         * specify up to five security groups, but we recommend that you use a dedicated security group for your cluster
         * control plane.
         * </p>
         * This is a convenience that creates an instance of the {@link VpcConfigRequest.Builder} avoiding the need to
         * create one manually via {@link VpcConfigRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcConfigRequest.Builder#build()} is called immediately and its
         * result is passed to {@link #resourcesVpcConfig(VpcConfigRequest)}.
         * 
         * @param resourcesVpcConfig
         *        a consumer that will call methods on {@link VpcConfigRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourcesVpcConfig(VpcConfigRequest)
         */
        default Builder resourcesVpcConfig(Consumer<VpcConfigRequest.Builder> resourcesVpcConfig) {
            return resourcesVpcConfig(VpcConfigRequest.builder().applyMutation(resourcesVpcConfig).build());
        }

        /**
         * <p>
         * Enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs. By
         * default, cluster control plane logs aren't exported to CloudWatch Logs. For more information, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html">Amazon EKS Cluster Control
         * Plane Logs</a> in the <i> <i>Amazon EKS User Guide</i> </i>.
         * </p>
         * <note>
         * <p>
         * CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs. For
         * more information, see <a href="http://aws.amazon.com/cloudwatch/pricing/">Amazon CloudWatch Pricing</a>.
         * </p>
         * </note>
         * 
         * @param logging
         *        Enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs. By
         *        default, cluster control plane logs aren't exported to CloudWatch Logs. For more information, see <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html">Amazon EKS Cluster
         *        Control Plane Logs</a> in the <i> <i>Amazon EKS User Guide</i> </i>.</p> <note>
         *        <p>
         *        CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane
         *        logs. For more information, see <a href="http://aws.amazon.com/cloudwatch/pricing/">Amazon CloudWatch
         *        Pricing</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logging(Logging logging);

        /**
         * <p>
         * Enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs. By
         * default, cluster control plane logs aren't exported to CloudWatch Logs. For more information, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html">Amazon EKS Cluster Control
         * Plane Logs</a> in the <i> <i>Amazon EKS User Guide</i> </i>.
         * </p>
         * <note>
         * <p>
         * CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs. For
         * more information, see <a href="http://aws.amazon.com/cloudwatch/pricing/">Amazon CloudWatch Pricing</a>.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link Logging.Builder} avoiding the need to
         * create one manually via {@link Logging#builder()}.
         *
         * When the {@link Consumer} completes, {@link Logging.Builder#build()} is called immediately and its result is
         * passed to {@link #logging(Logging)}.
         * 
         * @param logging
         *        a consumer that will call methods on {@link Logging.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logging(Logging)
         */
        default Builder logging(Consumer<Logging.Builder> logging) {
            return logging(Logging.builder().applyMutation(logging).build());
        }

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientRequestToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The metadata to apply to the cluster to assist with categorization and organization. Each tag consists of a
         * key and an optional value, both of which you define.
         * </p>
         * 
         * @param tags
         *        The metadata to apply to the cluster to assist with categorization and organization. Each tag consists
         *        of a key and an optional value, both of which you define.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The encryption configuration for the cluster.
         * </p>
         * 
         * @param encryptionConfig
         *        The encryption configuration for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfig(Collection<EncryptionConfig> encryptionConfig);

        /**
         * <p>
         * The encryption configuration for the cluster.
         * </p>
         * 
         * @param encryptionConfig
         *        The encryption configuration for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfig(EncryptionConfig... encryptionConfig);

        /**
         * <p>
         * The encryption configuration for the cluster.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EncryptionConfig>.Builder} avoiding the
         * need to create one manually via {@link List<EncryptionConfig>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EncryptionConfig>.Builder#build()} is called immediately and
         * its result is passed to {@link #encryptionConfig(List<EncryptionConfig>)}.
         * 
         * @param encryptionConfig
         *        a consumer that will call methods on {@link List<EncryptionConfig>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionConfig(List<EncryptionConfig>)
         */
        Builder encryptionConfig(Consumer<EncryptionConfig.Builder>... encryptionConfig);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EksRequest.BuilderImpl implements Builder {
        private String name;

        private String version;

        private String roleArn;

        private VpcConfigRequest resourcesVpcConfig;

        private Logging logging;

        private String clientRequestToken;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private List<EncryptionConfig> encryptionConfig = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClusterRequest model) {
            super(model);
            name(model.name);
            version(model.version);
            roleArn(model.roleArn);
            resourcesVpcConfig(model.resourcesVpcConfig);
            logging(model.logging);
            clientRequestToken(model.clientRequestToken);
            tags(model.tags);
            encryptionConfig(model.encryptionConfig);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final VpcConfigRequest.Builder getResourcesVpcConfig() {
            return resourcesVpcConfig != null ? resourcesVpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder resourcesVpcConfig(VpcConfigRequest resourcesVpcConfig) {
            this.resourcesVpcConfig = resourcesVpcConfig;
            return this;
        }

        public final void setResourcesVpcConfig(VpcConfigRequest.BuilderImpl resourcesVpcConfig) {
            this.resourcesVpcConfig = resourcesVpcConfig != null ? resourcesVpcConfig.build() : null;
        }

        public final Logging.Builder getLogging() {
            return logging != null ? logging.toBuilder() : null;
        }

        @Override
        public final Builder logging(Logging logging) {
            this.logging = logging;
            return this;
        }

        public final void setLogging(Logging.BuilderImpl logging) {
            this.logging = logging != null ? logging.build() : null;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        public final Collection<EncryptionConfig.Builder> getEncryptionConfig() {
            return encryptionConfig != null ? encryptionConfig.stream().map(EncryptionConfig::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder encryptionConfig(Collection<EncryptionConfig> encryptionConfig) {
            this.encryptionConfig = EncryptionConfigListCopier.copy(encryptionConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder encryptionConfig(EncryptionConfig... encryptionConfig) {
            encryptionConfig(Arrays.asList(encryptionConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder encryptionConfig(Consumer<EncryptionConfig.Builder>... encryptionConfig) {
            encryptionConfig(Stream.of(encryptionConfig).map(c -> EncryptionConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEncryptionConfig(Collection<EncryptionConfig.BuilderImpl> encryptionConfig) {
            this.encryptionConfig = EncryptionConfigListCopier.copyFromBuilder(encryptionConfig);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateClusterRequest build() {
            return new CreateClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
