/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateNodegroupConfigResponse extends EksResponse implements
        ToCopyableBuilder<UpdateNodegroupConfigResponse.Builder, UpdateNodegroupConfigResponse> {
    private static final SdkField<Update> UPDATE_FIELD = SdkField.<Update> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateNodegroupConfigResponse::update)).setter(setter(Builder::update)).constructor(Update::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("update").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPDATE_FIELD));

    private final Update update;

    private UpdateNodegroupConfigResponse(BuilderImpl builder) {
        super(builder);
        this.update = builder.update;
    }

    /**
     * Returns the value of the Update property for this object.
     * 
     * @return The value of the Update property for this object.
     */
    public Update update() {
        return update;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(update());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateNodegroupConfigResponse)) {
            return false;
        }
        UpdateNodegroupConfigResponse other = (UpdateNodegroupConfigResponse) obj;
        return Objects.equals(update(), other.update());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateNodegroupConfigResponse").add("Update", update()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "update":
            return Optional.ofNullable(clazz.cast(update()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateNodegroupConfigResponse, T> g) {
        return obj -> g.apply((UpdateNodegroupConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EksResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateNodegroupConfigResponse> {
        /**
         * Sets the value of the Update property for this object.
         *
         * @param update
         *        The new value for the Update property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder update(Update update);

        /**
         * Sets the value of the Update property for this object.
         *
         * This is a convenience that creates an instance of the {@link Update.Builder} avoiding the need to create one
         * manually via {@link Update#builder()}.
         *
         * When the {@link Consumer} completes, {@link Update.Builder#build()} is called immediately and its result is
         * passed to {@link #update(Update)}.
         * 
         * @param update
         *        a consumer that will call methods on {@link Update.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #update(Update)
         */
        default Builder update(Consumer<Update.Builder> update) {
            return update(Update.builder().applyMutation(update).build());
        }
    }

    static final class BuilderImpl extends EksResponse.BuilderImpl implements Builder {
        private Update update;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateNodegroupConfigResponse model) {
            super(model);
            update(model.update);
        }

        public final Update.Builder getUpdate() {
            return update != null ? update.toBuilder() : null;
        }

        @Override
        public final Builder update(Update update) {
            this.update = update;
            return this;
        }

        public final void setUpdate(Update.BuilderImpl update) {
            this.update = update != null ? update.build() : null;
        }

        @Override
        public UpdateNodegroupConfigResponse build() {
            return new UpdateNodegroupConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
