/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the enabled or disabled Kubernetes control plane logs for your cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LogSetup implements SdkPojo, Serializable, ToCopyableBuilder<LogSetup.Builder, LogSetup> {
    private static final SdkField<List<String>> TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(LogSetup::typesAsStrings))
            .setter(setter(Builder::typesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("types").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(LogSetup::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPES_FIELD, ENABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> types;

    private final Boolean enabled;

    private LogSetup(BuilderImpl builder) {
        this.types = builder.types;
        this.enabled = builder.enabled;
    }

    /**
     * <p>
     * The available cluster control plane log types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The available cluster control plane log types.
     */
    public List<LogType> types() {
        return LogTypesCopier.copyStringToEnum(types);
    }

    /**
     * Returns true if the Types property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTypes() {
        return types != null && !(types instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The available cluster control plane log types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The available cluster control plane log types.
     */
    public List<String> typesAsStrings() {
        return types;
    }

    /**
     * <p>
     * If a log type is enabled, that log type exports its control plane logs to CloudWatch Logs. If a log type isn't
     * enabled, that log type doesn't export its control plane logs. Each individual log type can be enabled or disabled
     * independently.
     * </p>
     * 
     * @return If a log type is enabled, that log type exports its control plane logs to CloudWatch Logs. If a log type
     *         isn't enabled, that log type doesn't export its control plane logs. Each individual log type can be
     *         enabled or disabled independently.
     */
    public Boolean enabled() {
        return enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogSetup)) {
            return false;
        }
        LogSetup other = (LogSetup) obj;
        return Objects.equals(typesAsStrings(), other.typesAsStrings()) && Objects.equals(enabled(), other.enabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LogSetup").add("Types", typesAsStrings()).add("Enabled", enabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "types":
            return Optional.ofNullable(clazz.cast(typesAsStrings()));
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LogSetup, T> g) {
        return obj -> g.apply((LogSetup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LogSetup> {
        /**
         * <p>
         * The available cluster control plane log types.
         * </p>
         * 
         * @param types
         *        The available cluster control plane log types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typesWithStrings(Collection<String> types);

        /**
         * <p>
         * The available cluster control plane log types.
         * </p>
         * 
         * @param types
         *        The available cluster control plane log types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typesWithStrings(String... types);

        /**
         * <p>
         * The available cluster control plane log types.
         * </p>
         * 
         * @param types
         *        The available cluster control plane log types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder types(Collection<LogType> types);

        /**
         * <p>
         * The available cluster control plane log types.
         * </p>
         * 
         * @param types
         *        The available cluster control plane log types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder types(LogType... types);

        /**
         * <p>
         * If a log type is enabled, that log type exports its control plane logs to CloudWatch Logs. If a log type
         * isn't enabled, that log type doesn't export its control plane logs. Each individual log type can be enabled
         * or disabled independently.
         * </p>
         * 
         * @param enabled
         *        If a log type is enabled, that log type exports its control plane logs to CloudWatch Logs. If a log
         *        type isn't enabled, that log type doesn't export its control plane logs. Each individual log type can
         *        be enabled or disabled independently.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);
    }

    static final class BuilderImpl implements Builder {
        private List<String> types = DefaultSdkAutoConstructList.getInstance();

        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(LogSetup model) {
            typesWithStrings(model.types);
            enabled(model.enabled);
        }

        public final Collection<String> getTypesAsStrings() {
            return types;
        }

        @Override
        public final Builder typesWithStrings(Collection<String> types) {
            this.types = LogTypesCopier.copy(types);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder typesWithStrings(String... types) {
            typesWithStrings(Arrays.asList(types));
            return this;
        }

        @Override
        public final Builder types(Collection<LogType> types) {
            this.types = LogTypesCopier.copyEnumToString(types);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder types(LogType... types) {
            types(Arrays.asList(types));
            return this;
        }

        public final void setTypesWithStrings(Collection<String> types) {
            this.types = LogTypesCopier.copy(types);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public LogSetup build() {
            return new LogSetup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
