/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FileSystemSize
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FileSystemSize> {
    private static final SdkField<Long> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(FileSystemSize.getter(FileSystemSize::value)).setter(FileSystemSize.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(FileSystemSize.getter(FileSystemSize::timestamp)).setter(FileSystemSize.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, TIMESTAMP_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long value;
    private final Instant timestamp;

    private FileSystemSize(BuilderImpl builder) {
        this.value = builder.value;
        this.timestamp = builder.timestamp;
    }

    public Long value() {
        return this.value;
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileSystemSize)) {
            return false;
        }
        FileSystemSize other = (FileSystemSize)obj;
        return Objects.equals(this.value(), other.value()) && Objects.equals(this.timestamp(), other.timestamp());
    }

    public String toString() {
        return ToString.builder((String)"FileSystemSize").add("Value", (Object)this.value()).add("Timestamp", (Object)this.timestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FileSystemSize, T> g) {
        return obj -> g.apply((FileSystemSize)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long value;
        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(FileSystemSize model) {
            this.value(model.value);
            this.timestamp(model.timestamp);
        }

        public final Long getValue() {
            return this.value;
        }

        @Override
        public final Builder value(Long value) {
            this.value = value;
            return this;
        }

        public final void setValue(Long value) {
            this.value = value;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public FileSystemSize build() {
            return new FileSystemSize(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FileSystemSize> {
        public Builder value(Long var1);

        public Builder timestamp(Instant var1);
    }
}

