/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.efs.EfsClient;
import software.amazon.awssdk.services.efs.internal.UserAgentUtils;
import software.amazon.awssdk.services.efs.model.DescribeReplicationConfigurationsRequest;
import software.amazon.awssdk.services.efs.model.DescribeReplicationConfigurationsResponse;
import software.amazon.awssdk.services.efs.model.ReplicationConfigurationDescription;

public class DescribeReplicationConfigurationsIterable
implements SdkIterable<DescribeReplicationConfigurationsResponse> {
    private final EfsClient client;
    private final DescribeReplicationConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeReplicationConfigurationsIterable(EfsClient client, DescribeReplicationConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeReplicationConfigurationsResponseFetcher();
    }

    public Iterator<DescribeReplicationConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ReplicationConfigurationDescription> replications() {
        Function<DescribeReplicationConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.replications() != null) {
                return response.replications().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeReplicationConfigurationsResponseFetcher
    implements SyncPageFetcher<DescribeReplicationConfigurationsResponse> {
        private DescribeReplicationConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReplicationConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeReplicationConfigurationsResponse nextPage(DescribeReplicationConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeReplicationConfigurationsIterable.this.client.describeReplicationConfigurations(DescribeReplicationConfigurationsIterable.this.firstRequest);
            }
            return DescribeReplicationConfigurationsIterable.this.client.describeReplicationConfigurations((DescribeReplicationConfigurationsRequest)((Object)DescribeReplicationConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

