/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.efs.model.Resource;
import software.amazon.awssdk.services.efs.model.ResourceIdType;
import software.amazon.awssdk.services.efs.model.ResourcesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceIdPreference
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceIdPreference> {
    private static final SdkField<String> RESOURCE_ID_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceIdType").getter(ResourceIdPreference.getter(ResourceIdPreference::resourceIdTypeAsString)).setter(ResourceIdPreference.setter(Builder::resourceIdType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdType").build()}).build();
    private static final SdkField<List<String>> RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Resources").getter(ResourceIdPreference.getter(ResourceIdPreference::resourcesAsStrings)).setter(ResourceIdPreference.setter(Builder::resourcesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_TYPE_FIELD, RESOURCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResourceIdPreference.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String resourceIdType;
    private final List<String> resources;

    private ResourceIdPreference(BuilderImpl builder) {
        this.resourceIdType = builder.resourceIdType;
        this.resources = builder.resources;
    }

    public final ResourceIdType resourceIdType() {
        return ResourceIdType.fromValue(this.resourceIdType);
    }

    public final String resourceIdTypeAsString() {
        return this.resourceIdType;
    }

    public final List<Resource> resources() {
        return ResourcesCopier.copyStringToEnum(this.resources);
    }

    public final boolean hasResources() {
        return this.resources != null && !(this.resources instanceof SdkAutoConstructList);
    }

    public final List<String> resourcesAsStrings() {
        return this.resources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceIdTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResources() ? this.resourcesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceIdPreference)) {
            return false;
        }
        ResourceIdPreference other = (ResourceIdPreference)obj;
        return Objects.equals(this.resourceIdTypeAsString(), other.resourceIdTypeAsString()) && this.hasResources() == other.hasResources() && Objects.equals(this.resourcesAsStrings(), other.resourcesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceIdPreference").add("ResourceIdType", (Object)this.resourceIdTypeAsString()).add("Resources", this.hasResources() ? this.resourcesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceIdType": {
                return Optional.ofNullable(clazz.cast(this.resourceIdTypeAsString()));
            }
            case "Resources": {
                return Optional.ofNullable(clazz.cast(this.resourcesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResourceIdType", RESOURCE_ID_TYPE_FIELD);
        map.put("Resources", RESOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceIdPreference, T> g) {
        return obj -> g.apply((ResourceIdPreference)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceIdType;
        private List<String> resources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceIdPreference model) {
            this.resourceIdType(model.resourceIdType);
            this.resourcesWithStrings(model.resources);
        }

        public final String getResourceIdType() {
            return this.resourceIdType;
        }

        public final void setResourceIdType(String resourceIdType) {
            this.resourceIdType = resourceIdType;
        }

        @Override
        public final Builder resourceIdType(String resourceIdType) {
            this.resourceIdType = resourceIdType;
            return this;
        }

        @Override
        public final Builder resourceIdType(ResourceIdType resourceIdType) {
            this.resourceIdType(resourceIdType == null ? null : resourceIdType.toString());
            return this;
        }

        public final Collection<String> getResources() {
            if (this.resources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resources;
        }

        public final void setResources(Collection<String> resources) {
            this.resources = ResourcesCopier.copy(resources);
        }

        @Override
        public final Builder resourcesWithStrings(Collection<String> resources) {
            this.resources = ResourcesCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourcesWithStrings(String ... resources) {
            this.resourcesWithStrings(Arrays.asList(resources));
            return this;
        }

        @Override
        public final Builder resources(Collection<Resource> resources) {
            this.resources = ResourcesCopier.copyEnumToString(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Resource ... resources) {
            this.resources(Arrays.asList(resources));
            return this;
        }

        public ResourceIdPreference build() {
            return new ResourceIdPreference(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceIdPreference> {
        public Builder resourceIdType(String var1);

        public Builder resourceIdType(ResourceIdType var1);

        public Builder resourcesWithStrings(Collection<String> var1);

        public Builder resourcesWithStrings(String ... var1);

        public Builder resources(Collection<Resource> var1);

        public Builder resources(Resource ... var1);
    }
}

