/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.efs.model.Destination;
import software.amazon.awssdk.services.efs.model.DestinationsCopier;
import software.amazon.awssdk.services.efs.model.EfsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateReplicationConfigurationResponse
extends EfsResponse
implements ToCopyableBuilder<Builder, CreateReplicationConfigurationResponse> {
    private static final SdkField<String> SOURCE_FILE_SYSTEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceFileSystemId").getter(CreateReplicationConfigurationResponse.getter(CreateReplicationConfigurationResponse::sourceFileSystemId)).setter(CreateReplicationConfigurationResponse.setter(Builder::sourceFileSystemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceFileSystemId").build()}).build();
    private static final SdkField<String> SOURCE_FILE_SYSTEM_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceFileSystemRegion").getter(CreateReplicationConfigurationResponse.getter(CreateReplicationConfigurationResponse::sourceFileSystemRegion)).setter(CreateReplicationConfigurationResponse.setter(Builder::sourceFileSystemRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceFileSystemRegion").build()}).build();
    private static final SdkField<String> SOURCE_FILE_SYSTEM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceFileSystemArn").getter(CreateReplicationConfigurationResponse.getter(CreateReplicationConfigurationResponse::sourceFileSystemArn)).setter(CreateReplicationConfigurationResponse.setter(Builder::sourceFileSystemArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceFileSystemArn").build()}).build();
    private static final SdkField<String> ORIGINAL_SOURCE_FILE_SYSTEM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OriginalSourceFileSystemArn").getter(CreateReplicationConfigurationResponse.getter(CreateReplicationConfigurationResponse::originalSourceFileSystemArn)).setter(CreateReplicationConfigurationResponse.setter(Builder::originalSourceFileSystemArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginalSourceFileSystemArn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(CreateReplicationConfigurationResponse.getter(CreateReplicationConfigurationResponse::creationTime)).setter(CreateReplicationConfigurationResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<List<Destination>> DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Destinations").getter(CreateReplicationConfigurationResponse.getter(CreateReplicationConfigurationResponse::destinations)).setter(CreateReplicationConfigurationResponse.setter(Builder::destinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Destination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SOURCE_FILE_SYSTEM_OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceFileSystemOwnerId").getter(CreateReplicationConfigurationResponse.getter(CreateReplicationConfigurationResponse::sourceFileSystemOwnerId)).setter(CreateReplicationConfigurationResponse.setter(Builder::sourceFileSystemOwnerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceFileSystemOwnerId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FILE_SYSTEM_ID_FIELD, SOURCE_FILE_SYSTEM_REGION_FIELD, SOURCE_FILE_SYSTEM_ARN_FIELD, ORIGINAL_SOURCE_FILE_SYSTEM_ARN_FIELD, CREATION_TIME_FIELD, DESTINATIONS_FIELD, SOURCE_FILE_SYSTEM_OWNER_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateReplicationConfigurationResponse.memberNameToFieldInitializer();
    private final String sourceFileSystemId;
    private final String sourceFileSystemRegion;
    private final String sourceFileSystemArn;
    private final String originalSourceFileSystemArn;
    private final Instant creationTime;
    private final List<Destination> destinations;
    private final String sourceFileSystemOwnerId;

    private CreateReplicationConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.sourceFileSystemId = builder.sourceFileSystemId;
        this.sourceFileSystemRegion = builder.sourceFileSystemRegion;
        this.sourceFileSystemArn = builder.sourceFileSystemArn;
        this.originalSourceFileSystemArn = builder.originalSourceFileSystemArn;
        this.creationTime = builder.creationTime;
        this.destinations = builder.destinations;
        this.sourceFileSystemOwnerId = builder.sourceFileSystemOwnerId;
    }

    public final String sourceFileSystemId() {
        return this.sourceFileSystemId;
    }

    public final String sourceFileSystemRegion() {
        return this.sourceFileSystemRegion;
    }

    public final String sourceFileSystemArn() {
        return this.sourceFileSystemArn;
    }

    public final String originalSourceFileSystemArn() {
        return this.originalSourceFileSystemArn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final boolean hasDestinations() {
        return this.destinations != null && !(this.destinations instanceof SdkAutoConstructList);
    }

    public final List<Destination> destinations() {
        return this.destinations;
    }

    public final String sourceFileSystemOwnerId() {
        return this.sourceFileSystemOwnerId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceFileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceFileSystemRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceFileSystemArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.originalSourceFileSystemArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinations() ? this.destinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceFileSystemOwnerId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReplicationConfigurationResponse)) {
            return false;
        }
        CreateReplicationConfigurationResponse other = (CreateReplicationConfigurationResponse)((Object)obj);
        return Objects.equals(this.sourceFileSystemId(), other.sourceFileSystemId()) && Objects.equals(this.sourceFileSystemRegion(), other.sourceFileSystemRegion()) && Objects.equals(this.sourceFileSystemArn(), other.sourceFileSystemArn()) && Objects.equals(this.originalSourceFileSystemArn(), other.originalSourceFileSystemArn()) && Objects.equals(this.creationTime(), other.creationTime()) && this.hasDestinations() == other.hasDestinations() && Objects.equals(this.destinations(), other.destinations()) && Objects.equals(this.sourceFileSystemOwnerId(), other.sourceFileSystemOwnerId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateReplicationConfigurationResponse").add("SourceFileSystemId", (Object)this.sourceFileSystemId()).add("SourceFileSystemRegion", (Object)this.sourceFileSystemRegion()).add("SourceFileSystemArn", (Object)this.sourceFileSystemArn()).add("OriginalSourceFileSystemArn", (Object)this.originalSourceFileSystemArn()).add("CreationTime", (Object)this.creationTime()).add("Destinations", this.hasDestinations() ? this.destinations() : null).add("SourceFileSystemOwnerId", (Object)this.sourceFileSystemOwnerId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceFileSystemId": {
                return Optional.ofNullable(clazz.cast(this.sourceFileSystemId()));
            }
            case "SourceFileSystemRegion": {
                return Optional.ofNullable(clazz.cast(this.sourceFileSystemRegion()));
            }
            case "SourceFileSystemArn": {
                return Optional.ofNullable(clazz.cast(this.sourceFileSystemArn()));
            }
            case "OriginalSourceFileSystemArn": {
                return Optional.ofNullable(clazz.cast(this.originalSourceFileSystemArn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "Destinations": {
                return Optional.ofNullable(clazz.cast(this.destinations()));
            }
            case "SourceFileSystemOwnerId": {
                return Optional.ofNullable(clazz.cast(this.sourceFileSystemOwnerId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SourceFileSystemId", SOURCE_FILE_SYSTEM_ID_FIELD);
        map.put("SourceFileSystemRegion", SOURCE_FILE_SYSTEM_REGION_FIELD);
        map.put("SourceFileSystemArn", SOURCE_FILE_SYSTEM_ARN_FIELD);
        map.put("OriginalSourceFileSystemArn", ORIGINAL_SOURCE_FILE_SYSTEM_ARN_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("Destinations", DESTINATIONS_FIELD);
        map.put("SourceFileSystemOwnerId", SOURCE_FILE_SYSTEM_OWNER_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateReplicationConfigurationResponse, T> g) {
        return obj -> g.apply((CreateReplicationConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EfsResponse.BuilderImpl
    implements Builder {
        private String sourceFileSystemId;
        private String sourceFileSystemRegion;
        private String sourceFileSystemArn;
        private String originalSourceFileSystemArn;
        private Instant creationTime;
        private List<Destination> destinations = DefaultSdkAutoConstructList.getInstance();
        private String sourceFileSystemOwnerId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReplicationConfigurationResponse model) {
            super(model);
            this.sourceFileSystemId(model.sourceFileSystemId);
            this.sourceFileSystemRegion(model.sourceFileSystemRegion);
            this.sourceFileSystemArn(model.sourceFileSystemArn);
            this.originalSourceFileSystemArn(model.originalSourceFileSystemArn);
            this.creationTime(model.creationTime);
            this.destinations(model.destinations);
            this.sourceFileSystemOwnerId(model.sourceFileSystemOwnerId);
        }

        public final String getSourceFileSystemId() {
            return this.sourceFileSystemId;
        }

        public final void setSourceFileSystemId(String sourceFileSystemId) {
            this.sourceFileSystemId = sourceFileSystemId;
        }

        @Override
        public final Builder sourceFileSystemId(String sourceFileSystemId) {
            this.sourceFileSystemId = sourceFileSystemId;
            return this;
        }

        public final String getSourceFileSystemRegion() {
            return this.sourceFileSystemRegion;
        }

        public final void setSourceFileSystemRegion(String sourceFileSystemRegion) {
            this.sourceFileSystemRegion = sourceFileSystemRegion;
        }

        @Override
        public final Builder sourceFileSystemRegion(String sourceFileSystemRegion) {
            this.sourceFileSystemRegion = sourceFileSystemRegion;
            return this;
        }

        public final String getSourceFileSystemArn() {
            return this.sourceFileSystemArn;
        }

        public final void setSourceFileSystemArn(String sourceFileSystemArn) {
            this.sourceFileSystemArn = sourceFileSystemArn;
        }

        @Override
        public final Builder sourceFileSystemArn(String sourceFileSystemArn) {
            this.sourceFileSystemArn = sourceFileSystemArn;
            return this;
        }

        public final String getOriginalSourceFileSystemArn() {
            return this.originalSourceFileSystemArn;
        }

        public final void setOriginalSourceFileSystemArn(String originalSourceFileSystemArn) {
            this.originalSourceFileSystemArn = originalSourceFileSystemArn;
        }

        @Override
        public final Builder originalSourceFileSystemArn(String originalSourceFileSystemArn) {
            this.originalSourceFileSystemArn = originalSourceFileSystemArn;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final List<Destination.Builder> getDestinations() {
            List<Destination.Builder> result = DestinationsCopier.copyToBuilder(this.destinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinations(Collection<Destination.BuilderImpl> destinations) {
            this.destinations = DestinationsCopier.copyFromBuilder(destinations);
        }

        @Override
        public final Builder destinations(Collection<Destination> destinations) {
            this.destinations = DestinationsCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Destination ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<Destination.Builder> ... destinations) {
            this.destinations(Stream.of(destinations).map(c -> (Destination)((Destination.Builder)Destination.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSourceFileSystemOwnerId() {
            return this.sourceFileSystemOwnerId;
        }

        public final void setSourceFileSystemOwnerId(String sourceFileSystemOwnerId) {
            this.sourceFileSystemOwnerId = sourceFileSystemOwnerId;
        }

        @Override
        public final Builder sourceFileSystemOwnerId(String sourceFileSystemOwnerId) {
            this.sourceFileSystemOwnerId = sourceFileSystemOwnerId;
            return this;
        }

        @Override
        public CreateReplicationConfigurationResponse build() {
            return new CreateReplicationConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EfsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateReplicationConfigurationResponse> {
        public Builder sourceFileSystemId(String var1);

        public Builder sourceFileSystemRegion(String var1);

        public Builder sourceFileSystemArn(String var1);

        public Builder originalSourceFileSystemArn(String var1);

        public Builder creationTime(Instant var1);

        public Builder destinations(Collection<Destination> var1);

        public Builder destinations(Destination ... var1);

        public Builder destinations(Consumer<Destination.Builder> ... var1);

        public Builder sourceFileSystemOwnerId(String var1);
    }
}

