/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.efs.EfsAsyncClient;
import software.amazon.awssdk.services.efs.internal.UserAgentUtils;
import software.amazon.awssdk.services.efs.model.DescribeAccessPointsRequest;
import software.amazon.awssdk.services.efs.model.DescribeAccessPointsResponse;

public class DescribeAccessPointsPublisher
implements SdkPublisher<DescribeAccessPointsResponse> {
    private final EfsAsyncClient client;
    private final DescribeAccessPointsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeAccessPointsPublisher(EfsAsyncClient client, DescribeAccessPointsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeAccessPointsPublisher(EfsAsyncClient client, DescribeAccessPointsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeAccessPointsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeAccessPointsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeAccessPointsResponseFetcher
    implements AsyncPageFetcher<DescribeAccessPointsResponse> {
        private DescribeAccessPointsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAccessPointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeAccessPointsResponse> nextPage(DescribeAccessPointsResponse previousPage) {
            if (previousPage == null) {
                return DescribeAccessPointsPublisher.this.client.describeAccessPoints(DescribeAccessPointsPublisher.this.firstRequest);
            }
            return DescribeAccessPointsPublisher.this.client.describeAccessPoints((DescribeAccessPointsRequest)((Object)DescribeAccessPointsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

