/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.efs.EfsClient;
import software.amazon.awssdk.services.efs.model.AccessPointAlreadyExistsException;
import software.amazon.awssdk.services.efs.model.AccessPointLimitExceededException;
import software.amazon.awssdk.services.efs.model.AccessPointNotFoundException;
import software.amazon.awssdk.services.efs.model.AvailabilityZonesMismatchException;
import software.amazon.awssdk.services.efs.model.BadRequestException;
import software.amazon.awssdk.services.efs.model.CreateAccessPointRequest;
import software.amazon.awssdk.services.efs.model.CreateAccessPointResponse;
import software.amazon.awssdk.services.efs.model.CreateFileSystemRequest;
import software.amazon.awssdk.services.efs.model.CreateFileSystemResponse;
import software.amazon.awssdk.services.efs.model.CreateMountTargetRequest;
import software.amazon.awssdk.services.efs.model.CreateMountTargetResponse;
import software.amazon.awssdk.services.efs.model.CreateReplicationConfigurationRequest;
import software.amazon.awssdk.services.efs.model.CreateReplicationConfigurationResponse;
import software.amazon.awssdk.services.efs.model.CreateTagsRequest;
import software.amazon.awssdk.services.efs.model.CreateTagsResponse;
import software.amazon.awssdk.services.efs.model.DeleteAccessPointRequest;
import software.amazon.awssdk.services.efs.model.DeleteAccessPointResponse;
import software.amazon.awssdk.services.efs.model.DeleteFileSystemPolicyRequest;
import software.amazon.awssdk.services.efs.model.DeleteFileSystemPolicyResponse;
import software.amazon.awssdk.services.efs.model.DeleteFileSystemRequest;
import software.amazon.awssdk.services.efs.model.DeleteFileSystemResponse;
import software.amazon.awssdk.services.efs.model.DeleteMountTargetRequest;
import software.amazon.awssdk.services.efs.model.DeleteMountTargetResponse;
import software.amazon.awssdk.services.efs.model.DeleteReplicationConfigurationRequest;
import software.amazon.awssdk.services.efs.model.DeleteReplicationConfigurationResponse;
import software.amazon.awssdk.services.efs.model.DeleteTagsRequest;
import software.amazon.awssdk.services.efs.model.DeleteTagsResponse;
import software.amazon.awssdk.services.efs.model.DependencyTimeoutException;
import software.amazon.awssdk.services.efs.model.DescribeAccessPointsRequest;
import software.amazon.awssdk.services.efs.model.DescribeAccessPointsResponse;
import software.amazon.awssdk.services.efs.model.DescribeAccountPreferencesRequest;
import software.amazon.awssdk.services.efs.model.DescribeAccountPreferencesResponse;
import software.amazon.awssdk.services.efs.model.DescribeBackupPolicyRequest;
import software.amazon.awssdk.services.efs.model.DescribeBackupPolicyResponse;
import software.amazon.awssdk.services.efs.model.DescribeFileSystemPolicyRequest;
import software.amazon.awssdk.services.efs.model.DescribeFileSystemPolicyResponse;
import software.amazon.awssdk.services.efs.model.DescribeFileSystemsRequest;
import software.amazon.awssdk.services.efs.model.DescribeFileSystemsResponse;
import software.amazon.awssdk.services.efs.model.DescribeLifecycleConfigurationRequest;
import software.amazon.awssdk.services.efs.model.DescribeLifecycleConfigurationResponse;
import software.amazon.awssdk.services.efs.model.DescribeMountTargetSecurityGroupsRequest;
import software.amazon.awssdk.services.efs.model.DescribeMountTargetSecurityGroupsResponse;
import software.amazon.awssdk.services.efs.model.DescribeMountTargetsRequest;
import software.amazon.awssdk.services.efs.model.DescribeMountTargetsResponse;
import software.amazon.awssdk.services.efs.model.DescribeReplicationConfigurationsRequest;
import software.amazon.awssdk.services.efs.model.DescribeReplicationConfigurationsResponse;
import software.amazon.awssdk.services.efs.model.DescribeTagsRequest;
import software.amazon.awssdk.services.efs.model.DescribeTagsResponse;
import software.amazon.awssdk.services.efs.model.EfsException;
import software.amazon.awssdk.services.efs.model.EfsRequest;
import software.amazon.awssdk.services.efs.model.FileSystemAlreadyExistsException;
import software.amazon.awssdk.services.efs.model.FileSystemInUseException;
import software.amazon.awssdk.services.efs.model.FileSystemLimitExceededException;
import software.amazon.awssdk.services.efs.model.FileSystemNotFoundException;
import software.amazon.awssdk.services.efs.model.IncorrectFileSystemLifeCycleStateException;
import software.amazon.awssdk.services.efs.model.IncorrectMountTargetStateException;
import software.amazon.awssdk.services.efs.model.InsufficientThroughputCapacityException;
import software.amazon.awssdk.services.efs.model.InternalServerErrorException;
import software.amazon.awssdk.services.efs.model.InvalidPolicyException;
import software.amazon.awssdk.services.efs.model.IpAddressInUseException;
import software.amazon.awssdk.services.efs.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.efs.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.efs.model.ModifyMountTargetSecurityGroupsRequest;
import software.amazon.awssdk.services.efs.model.ModifyMountTargetSecurityGroupsResponse;
import software.amazon.awssdk.services.efs.model.MountTargetConflictException;
import software.amazon.awssdk.services.efs.model.MountTargetNotFoundException;
import software.amazon.awssdk.services.efs.model.NetworkInterfaceLimitExceededException;
import software.amazon.awssdk.services.efs.model.NoFreeAddressesInSubnetException;
import software.amazon.awssdk.services.efs.model.PolicyNotFoundException;
import software.amazon.awssdk.services.efs.model.PutAccountPreferencesRequest;
import software.amazon.awssdk.services.efs.model.PutAccountPreferencesResponse;
import software.amazon.awssdk.services.efs.model.PutBackupPolicyRequest;
import software.amazon.awssdk.services.efs.model.PutBackupPolicyResponse;
import software.amazon.awssdk.services.efs.model.PutFileSystemPolicyRequest;
import software.amazon.awssdk.services.efs.model.PutFileSystemPolicyResponse;
import software.amazon.awssdk.services.efs.model.PutLifecycleConfigurationRequest;
import software.amazon.awssdk.services.efs.model.PutLifecycleConfigurationResponse;
import software.amazon.awssdk.services.efs.model.ReplicationNotFoundException;
import software.amazon.awssdk.services.efs.model.SecurityGroupLimitExceededException;
import software.amazon.awssdk.services.efs.model.SecurityGroupNotFoundException;
import software.amazon.awssdk.services.efs.model.SubnetNotFoundException;
import software.amazon.awssdk.services.efs.model.TagResourceRequest;
import software.amazon.awssdk.services.efs.model.TagResourceResponse;
import software.amazon.awssdk.services.efs.model.ThrottlingException;
import software.amazon.awssdk.services.efs.model.ThroughputLimitExceededException;
import software.amazon.awssdk.services.efs.model.TooManyRequestsException;
import software.amazon.awssdk.services.efs.model.UnsupportedAvailabilityZoneException;
import software.amazon.awssdk.services.efs.model.UntagResourceRequest;
import software.amazon.awssdk.services.efs.model.UntagResourceResponse;
import software.amazon.awssdk.services.efs.model.UpdateFileSystemRequest;
import software.amazon.awssdk.services.efs.model.UpdateFileSystemResponse;
import software.amazon.awssdk.services.efs.model.ValidationException;
import software.amazon.awssdk.services.efs.paginators.DescribeAccessPointsIterable;
import software.amazon.awssdk.services.efs.paginators.DescribeFileSystemsIterable;
import software.amazon.awssdk.services.efs.paginators.DescribeTagsIterable;
import software.amazon.awssdk.services.efs.paginators.ListTagsForResourceIterable;
import software.amazon.awssdk.services.efs.transform.CreateAccessPointRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.CreateFileSystemRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.CreateMountTargetRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.CreateReplicationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.CreateTagsRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.DeleteAccessPointRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.DeleteFileSystemPolicyRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.DeleteFileSystemRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.DeleteMountTargetRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.DeleteReplicationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.DeleteTagsRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.DescribeAccessPointsRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.DescribeAccountPreferencesRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.DescribeBackupPolicyRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.DescribeFileSystemPolicyRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.DescribeFileSystemsRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.DescribeLifecycleConfigurationRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.DescribeMountTargetSecurityGroupsRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.DescribeMountTargetsRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.DescribeReplicationConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.DescribeTagsRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.ModifyMountTargetSecurityGroupsRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.PutAccountPreferencesRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.PutBackupPolicyRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.PutFileSystemPolicyRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.PutLifecycleConfigurationRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.efs.transform.UpdateFileSystemRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultEfsClient
implements EfsClient {
    private static final Logger log = Logger.loggerFor(DefaultEfsClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultEfsClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "elasticfilesystem";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAccessPointResponse createAccessPoint(CreateAccessPointRequest createAccessPointRequest) throws BadRequestException, AccessPointAlreadyExistsException, IncorrectFileSystemLifeCycleStateException, InternalServerErrorException, FileSystemNotFoundException, AccessPointLimitExceededException, ThrottlingException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAccessPointResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(this.clientConfiguration, createAccessPointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAccessPoint");
            CreateAccessPointResponse createAccessPointResponse = (CreateAccessPointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAccessPoint").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createAccessPointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateAccessPointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAccessPointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$createAccessPoint$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateFileSystemResponse createFileSystem(CreateFileSystemRequest createFileSystemRequest) throws BadRequestException, InternalServerErrorException, FileSystemAlreadyExistsException, FileSystemLimitExceededException, InsufficientThroughputCapacityException, ThroughputLimitExceededException, UnsupportedAvailabilityZoneException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateFileSystemResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(this.clientConfiguration, createFileSystemRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFileSystem");
            CreateFileSystemResponse createFileSystemResponse = (CreateFileSystemResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFileSystem").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createFileSystemRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateFileSystemRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createFileSystemResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$createFileSystem$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateMountTargetResponse createMountTarget(CreateMountTargetRequest createMountTargetRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, IncorrectFileSystemLifeCycleStateException, MountTargetConflictException, SubnetNotFoundException, NoFreeAddressesInSubnetException, IpAddressInUseException, NetworkInterfaceLimitExceededException, SecurityGroupLimitExceededException, SecurityGroupNotFoundException, UnsupportedAvailabilityZoneException, AvailabilityZonesMismatchException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateMountTargetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(this.clientConfiguration, createMountTargetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateMountTarget");
            CreateMountTargetResponse createMountTargetResponse = (CreateMountTargetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateMountTarget").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createMountTargetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateMountTargetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createMountTargetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$createMountTarget$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateReplicationConfigurationResponse createReplicationConfiguration(CreateReplicationConfigurationRequest createReplicationConfigurationRequest) throws BadRequestException, IncorrectFileSystemLifeCycleStateException, ValidationException, ReplicationNotFoundException, FileSystemNotFoundException, UnsupportedAvailabilityZoneException, FileSystemLimitExceededException, InsufficientThroughputCapacityException, ThroughputLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateReplicationConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(this.clientConfiguration, createReplicationConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateReplicationConfiguration");
            CreateReplicationConfigurationResponse createReplicationConfigurationResponse = (CreateReplicationConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateReplicationConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createReplicationConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateReplicationConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createReplicationConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$createReplicationConfiguration$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTagsResponse createTags(CreateTagsRequest createTagsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTagsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(this.clientConfiguration, createTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTags");
            CreateTagsResponse createTagsResponse = (CreateTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$createTags$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAccessPointResponse deleteAccessPoint(DeleteAccessPointRequest deleteAccessPointRequest) throws BadRequestException, InternalServerErrorException, AccessPointNotFoundException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAccessPointResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(this.clientConfiguration, deleteAccessPointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAccessPoint");
            DeleteAccessPointResponse deleteAccessPointResponse = (DeleteAccessPointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAccessPoint").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteAccessPointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAccessPointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAccessPointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$deleteAccessPoint$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteFileSystemResponse deleteFileSystem(DeleteFileSystemRequest deleteFileSystemRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, FileSystemInUseException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFileSystemResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(this.clientConfiguration, deleteFileSystemRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFileSystem");
            DeleteFileSystemResponse deleteFileSystemResponse = (DeleteFileSystemResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFileSystem").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteFileSystemRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteFileSystemRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteFileSystemResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$deleteFileSystem$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteFileSystemPolicyResponse deleteFileSystemPolicy(DeleteFileSystemPolicyRequest deleteFileSystemPolicyRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, IncorrectFileSystemLifeCycleStateException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFileSystemPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(this.clientConfiguration, deleteFileSystemPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFileSystemPolicy");
            DeleteFileSystemPolicyResponse deleteFileSystemPolicyResponse = (DeleteFileSystemPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFileSystemPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteFileSystemPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteFileSystemPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteFileSystemPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$deleteFileSystemPolicy$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteMountTargetResponse deleteMountTarget(DeleteMountTargetRequest deleteMountTargetRequest) throws BadRequestException, InternalServerErrorException, DependencyTimeoutException, MountTargetNotFoundException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteMountTargetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(this.clientConfiguration, deleteMountTargetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteMountTarget");
            DeleteMountTargetResponse deleteMountTargetResponse = (DeleteMountTargetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteMountTarget").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteMountTargetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteMountTargetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteMountTargetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$deleteMountTarget$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteReplicationConfigurationResponse deleteReplicationConfiguration(DeleteReplicationConfigurationRequest deleteReplicationConfigurationRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, ReplicationNotFoundException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteReplicationConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(this.clientConfiguration, deleteReplicationConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteReplicationConfiguration");
            DeleteReplicationConfigurationResponse deleteReplicationConfigurationResponse = (DeleteReplicationConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteReplicationConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteReplicationConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteReplicationConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteReplicationConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$deleteReplicationConfiguration$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTagsResponse deleteTags(DeleteTagsRequest deleteTagsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTagsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(this.clientConfiguration, deleteTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTags");
            DeleteTagsResponse deleteTagsResponse = (DeleteTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$deleteTags$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAccessPointsResponse describeAccessPoints(DescribeAccessPointsRequest describeAccessPointsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AccessPointNotFoundException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAccessPointsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(this.clientConfiguration, describeAccessPointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAccessPoints");
            DescribeAccessPointsResponse describeAccessPointsResponse = (DescribeAccessPointsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAccessPoints").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAccessPointsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAccessPointsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAccessPointsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$describeAccessPoints$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeAccessPointsIterable describeAccessPointsPaginator(DescribeAccessPointsRequest describeAccessPointsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AccessPointNotFoundException, AwsServiceException, SdkClientException, EfsException {
        return new DescribeAccessPointsIterable(this, this.applyPaginatorUserAgent(describeAccessPointsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAccountPreferencesResponse describeAccountPreferences(DescribeAccountPreferencesRequest describeAccountPreferencesRequest) throws InternalServerErrorException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAccountPreferencesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(this.clientConfiguration, describeAccountPreferencesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAccountPreferences");
            DescribeAccountPreferencesResponse describeAccountPreferencesResponse = (DescribeAccountPreferencesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAccountPreferences").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAccountPreferencesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAccountPreferencesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAccountPreferencesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$describeAccountPreferences$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeBackupPolicyResponse describeBackupPolicy(DescribeBackupPolicyRequest describeBackupPolicyRequest) throws BadRequestException, FileSystemNotFoundException, InternalServerErrorException, PolicyNotFoundException, ValidationException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeBackupPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(this.clientConfiguration, describeBackupPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeBackupPolicy");
            DescribeBackupPolicyResponse describeBackupPolicyResponse = (DescribeBackupPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeBackupPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeBackupPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeBackupPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeBackupPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$describeBackupPolicy$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFileSystemPolicyResponse describeFileSystemPolicy(DescribeFileSystemPolicyRequest describeFileSystemPolicyRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, PolicyNotFoundException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFileSystemPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(this.clientConfiguration, describeFileSystemPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFileSystemPolicy");
            DescribeFileSystemPolicyResponse describeFileSystemPolicyResponse = (DescribeFileSystemPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFileSystemPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeFileSystemPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeFileSystemPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeFileSystemPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$describeFileSystemPolicy$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFileSystemsResponse describeFileSystems(DescribeFileSystemsRequest describeFileSystemsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFileSystemsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(this.clientConfiguration, describeFileSystemsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFileSystems");
            DescribeFileSystemsResponse describeFileSystemsResponse = (DescribeFileSystemsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFileSystems").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeFileSystemsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeFileSystemsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeFileSystemsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$describeFileSystems$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeFileSystemsIterable describeFileSystemsPaginator(DescribeFileSystemsRequest describeFileSystemsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AwsServiceException, SdkClientException, EfsException {
        return new DescribeFileSystemsIterable(this, this.applyPaginatorUserAgent(describeFileSystemsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeLifecycleConfigurationResponse describeLifecycleConfiguration(DescribeLifecycleConfigurationRequest describeLifecycleConfigurationRequest) throws InternalServerErrorException, BadRequestException, FileSystemNotFoundException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeLifecycleConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(this.clientConfiguration, describeLifecycleConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLifecycleConfiguration");
            DescribeLifecycleConfigurationResponse describeLifecycleConfigurationResponse = (DescribeLifecycleConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLifecycleConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLifecycleConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeLifecycleConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeLifecycleConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$describeLifecycleConfiguration$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeMountTargetSecurityGroupsResponse describeMountTargetSecurityGroups(DescribeMountTargetSecurityGroupsRequest describeMountTargetSecurityGroupsRequest) throws BadRequestException, InternalServerErrorException, MountTargetNotFoundException, IncorrectMountTargetStateException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeMountTargetSecurityGroupsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(this.clientConfiguration, describeMountTargetSecurityGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeMountTargetSecurityGroups");
            DescribeMountTargetSecurityGroupsResponse describeMountTargetSecurityGroupsResponse = (DescribeMountTargetSecurityGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeMountTargetSecurityGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeMountTargetSecurityGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeMountTargetSecurityGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeMountTargetSecurityGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$describeMountTargetSecurityGroups$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeMountTargetsResponse describeMountTargets(DescribeMountTargetsRequest describeMountTargetsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, MountTargetNotFoundException, AccessPointNotFoundException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeMountTargetsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(this.clientConfiguration, describeMountTargetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeMountTargets");
            DescribeMountTargetsResponse describeMountTargetsResponse = (DescribeMountTargetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeMountTargets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeMountTargetsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeMountTargetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeMountTargetsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$describeMountTargets$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeReplicationConfigurationsResponse describeReplicationConfigurations(DescribeReplicationConfigurationsRequest describeReplicationConfigurationsRequest) throws BadRequestException, FileSystemNotFoundException, InternalServerErrorException, ReplicationNotFoundException, ValidationException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeReplicationConfigurationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(this.clientConfiguration, describeReplicationConfigurationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeReplicationConfigurations");
            DescribeReplicationConfigurationsResponse describeReplicationConfigurationsResponse = (DescribeReplicationConfigurationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReplicationConfigurations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeReplicationConfigurationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeReplicationConfigurationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeReplicationConfigurationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$describeReplicationConfigurations$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTagsResponse describeTags(DescribeTagsRequest describeTagsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTagsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(this.clientConfiguration, describeTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTags");
            DescribeTagsResponse describeTagsResponse = (DescribeTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$describeTags$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeTagsIterable describeTagsPaginator(DescribeTagsRequest describeTagsRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AwsServiceException, SdkClientException, EfsException {
        return new DescribeTagsIterable(this, this.applyPaginatorUserAgent(describeTagsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AccessPointNotFoundException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$listTagsForResource$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListTagsForResourceIterable listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AccessPointNotFoundException, AwsServiceException, SdkClientException, EfsException {
        return new ListTagsForResourceIterable(this, this.applyPaginatorUserAgent(listTagsForResourceRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyMountTargetSecurityGroupsResponse modifyMountTargetSecurityGroups(ModifyMountTargetSecurityGroupsRequest modifyMountTargetSecurityGroupsRequest) throws BadRequestException, InternalServerErrorException, MountTargetNotFoundException, IncorrectMountTargetStateException, SecurityGroupLimitExceededException, SecurityGroupNotFoundException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ModifyMountTargetSecurityGroupsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(this.clientConfiguration, modifyMountTargetSecurityGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyMountTargetSecurityGroups");
            ModifyMountTargetSecurityGroupsResponse modifyMountTargetSecurityGroupsResponse = (ModifyMountTargetSecurityGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyMountTargetSecurityGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyMountTargetSecurityGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ModifyMountTargetSecurityGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return modifyMountTargetSecurityGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$modifyMountTargetSecurityGroups$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutAccountPreferencesResponse putAccountPreferences(PutAccountPreferencesRequest putAccountPreferencesRequest) throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutAccountPreferencesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(this.clientConfiguration, putAccountPreferencesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAccountPreferences");
            PutAccountPreferencesResponse putAccountPreferencesResponse = (PutAccountPreferencesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAccountPreferences").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putAccountPreferencesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutAccountPreferencesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putAccountPreferencesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$putAccountPreferences$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutBackupPolicyResponse putBackupPolicy(PutBackupPolicyRequest putBackupPolicyRequest) throws BadRequestException, FileSystemNotFoundException, IncorrectFileSystemLifeCycleStateException, InternalServerErrorException, ValidationException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutBackupPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(this.clientConfiguration, putBackupPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutBackupPolicy");
            PutBackupPolicyResponse putBackupPolicyResponse = (PutBackupPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBackupPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putBackupPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutBackupPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putBackupPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$putBackupPolicy$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutFileSystemPolicyResponse putFileSystemPolicy(PutFileSystemPolicyRequest putFileSystemPolicyRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, InvalidPolicyException, IncorrectFileSystemLifeCycleStateException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutFileSystemPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(this.clientConfiguration, putFileSystemPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutFileSystemPolicy");
            PutFileSystemPolicyResponse putFileSystemPolicyResponse = (PutFileSystemPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutFileSystemPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putFileSystemPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutFileSystemPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putFileSystemPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$putFileSystemPolicy$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutLifecycleConfigurationResponse putLifecycleConfiguration(PutLifecycleConfigurationRequest putLifecycleConfigurationRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, IncorrectFileSystemLifeCycleStateException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutLifecycleConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(this.clientConfiguration, putLifecycleConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutLifecycleConfiguration");
            PutLifecycleConfigurationResponse putLifecycleConfigurationResponse = (PutLifecycleConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutLifecycleConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putLifecycleConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutLifecycleConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putLifecycleConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$putLifecycleConfiguration$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AccessPointNotFoundException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$tagResource$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AccessPointNotFoundException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$untagResource$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateFileSystemResponse updateFileSystem(UpdateFileSystemRequest updateFileSystemRequest) throws BadRequestException, FileSystemNotFoundException, IncorrectFileSystemLifeCycleStateException, InsufficientThroughputCapacityException, InternalServerErrorException, ThroughputLimitExceededException, TooManyRequestsException, AwsServiceException, SdkClientException, EfsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFileSystemResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultEfsClient.resolveMetricPublishers(this.clientConfiguration, updateFileSystemRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EFS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFileSystem");
            UpdateFileSystemResponse updateFileSystemResponse = (UpdateFileSystemResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFileSystem").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateFileSystemRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateFileSystemRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateFileSystemResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEfsClient.lambda$updateFileSystem$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(EfsException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("IpAddressInUse").exceptionBuilderSupplier(IpAddressInUseException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FileSystemInUse").exceptionBuilderSupplier(FileSystemInUseException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FileSystemAlreadyExists").exceptionBuilderSupplier(FileSystemAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessPointAlreadyExists").exceptionBuilderSupplier(AccessPointAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IncorrectFileSystemLifeCycleState").exceptionBuilderSupplier(IncorrectFileSystemLifeCycleStateException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessPointLimitExceeded").exceptionBuilderSupplier(AccessPointLimitExceededException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoFreeAddressesInSubnet").exceptionBuilderSupplier(NoFreeAddressesInSubnetException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FileSystemNotFound").exceptionBuilderSupplier(FileSystemNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientThroughputCapacity").exceptionBuilderSupplier(InsufficientThroughputCapacityException::builder).httpStatusCode(Integer.valueOf(503)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SecurityGroupLimitExceeded").exceptionBuilderSupplier(SecurityGroupLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PolicyNotFound").exceptionBuilderSupplier(PolicyNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FileSystemLimitExceeded").exceptionBuilderSupplier(FileSystemLimitExceededException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedAvailabilityZone").exceptionBuilderSupplier(UnsupportedAvailabilityZoneException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessPointNotFound").exceptionBuilderSupplier(AccessPointNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MountTargetConflict").exceptionBuilderSupplier(MountTargetConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidPolicyException").exceptionBuilderSupplier(InvalidPolicyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SecurityGroupNotFound").exceptionBuilderSupplier(SecurityGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NetworkInterfaceLimitExceeded").exceptionBuilderSupplier(NetworkInterfaceLimitExceededException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReplicationNotFound").exceptionBuilderSupplier(ReplicationNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MountTargetNotFound").exceptionBuilderSupplier(MountTargetNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SubnetNotFound").exceptionBuilderSupplier(SubnetNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IncorrectMountTargetState").exceptionBuilderSupplier(IncorrectMountTargetStateException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThroughputLimitExceeded").exceptionBuilderSupplier(ThroughputLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DependencyTimeout").exceptionBuilderSupplier(DependencyTimeoutException::builder).httpStatusCode(Integer.valueOf(504)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AvailabilityZonesMismatch").exceptionBuilderSupplier(AvailabilityZonesMismatchException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyRequests").exceptionBuilderSupplier(TooManyRequestsException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BadRequest").exceptionBuilderSupplier(BadRequestException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerError").exceptionBuilderSupplier(InternalServerErrorException::builder).httpStatusCode(Integer.valueOf(500)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends EfsRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.19.33").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((EfsRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$updateFileSystem$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putLifecycleConfiguration$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putFileSystemPolicy$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putBackupPolicy$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putAccountPreferences$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyMountTargetSecurityGroups$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTags$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeReplicationConfigurations$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeMountTargets$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeMountTargetSecurityGroups$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeLifecycleConfiguration$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeFileSystems$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeFileSystemPolicy$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeBackupPolicy$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAccountPreferences$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAccessPoints$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTags$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteReplicationConfiguration$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteMountTarget$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteFileSystemPolicy$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteFileSystem$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAccessPoint$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createTags$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createReplicationConfiguration$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createMountTarget$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createFileSystem$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAccessPoint$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

