/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.efs.model.EfsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutFileSystemPolicyRequest
extends EfsRequest
implements ToCopyableBuilder<Builder, PutFileSystemPolicyRequest> {
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutFileSystemPolicyRequest.getter(PutFileSystemPolicyRequest::fileSystemId)).setter(PutFileSystemPolicyRequest.setter(Builder::fileSystemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("FileSystemId").build()}).build();
    private static final SdkField<String> POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutFileSystemPolicyRequest.getter(PutFileSystemPolicyRequest::policy)).setter(PutFileSystemPolicyRequest.setter(Builder::policy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policy").build()}).build();
    private static final SdkField<Boolean> BYPASS_POLICY_LOCKOUT_SAFETY_CHECK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(PutFileSystemPolicyRequest.getter(PutFileSystemPolicyRequest::bypassPolicyLockoutSafetyCheck)).setter(PutFileSystemPolicyRequest.setter(Builder::bypassPolicyLockoutSafetyCheck)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BypassPolicyLockoutSafetyCheck").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SYSTEM_ID_FIELD, POLICY_FIELD, BYPASS_POLICY_LOCKOUT_SAFETY_CHECK_FIELD));
    private final String fileSystemId;
    private final String policy;
    private final Boolean bypassPolicyLockoutSafetyCheck;

    private PutFileSystemPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.fileSystemId = builder.fileSystemId;
        this.policy = builder.policy;
        this.bypassPolicyLockoutSafetyCheck = builder.bypassPolicyLockoutSafetyCheck;
    }

    public String fileSystemId() {
        return this.fileSystemId;
    }

    public String policy() {
        return this.policy;
    }

    public Boolean bypassPolicyLockoutSafetyCheck() {
        return this.bypassPolicyLockoutSafetyCheck;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.policy());
        hashCode = 31 * hashCode + Objects.hashCode(this.bypassPolicyLockoutSafetyCheck());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutFileSystemPolicyRequest)) {
            return false;
        }
        PutFileSystemPolicyRequest other = (PutFileSystemPolicyRequest)((Object)obj);
        return Objects.equals(this.fileSystemId(), other.fileSystemId()) && Objects.equals(this.policy(), other.policy()) && Objects.equals(this.bypassPolicyLockoutSafetyCheck(), other.bypassPolicyLockoutSafetyCheck());
    }

    public String toString() {
        return ToString.builder((String)"PutFileSystemPolicyRequest").add("FileSystemId", (Object)this.fileSystemId()).add("Policy", (Object)this.policy()).add("BypassPolicyLockoutSafetyCheck", (Object)this.bypassPolicyLockoutSafetyCheck()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FileSystemId": {
                return Optional.ofNullable(clazz.cast(this.fileSystemId()));
            }
            case "Policy": {
                return Optional.ofNullable(clazz.cast(this.policy()));
            }
            case "BypassPolicyLockoutSafetyCheck": {
                return Optional.ofNullable(clazz.cast(this.bypassPolicyLockoutSafetyCheck()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutFileSystemPolicyRequest, T> g) {
        return obj -> g.apply((PutFileSystemPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EfsRequest.BuilderImpl
    implements Builder {
        private String fileSystemId;
        private String policy;
        private Boolean bypassPolicyLockoutSafetyCheck;

        private BuilderImpl() {
        }

        private BuilderImpl(PutFileSystemPolicyRequest model) {
            super(model);
            this.fileSystemId(model.fileSystemId);
            this.policy(model.policy);
            this.bypassPolicyLockoutSafetyCheck(model.bypassPolicyLockoutSafetyCheck);
        }

        public final String getFileSystemId() {
            return this.fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        public final String getPolicy() {
            return this.policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        public final Boolean getBypassPolicyLockoutSafetyCheck() {
            return this.bypassPolicyLockoutSafetyCheck;
        }

        @Override
        public final Builder bypassPolicyLockoutSafetyCheck(Boolean bypassPolicyLockoutSafetyCheck) {
            this.bypassPolicyLockoutSafetyCheck = bypassPolicyLockoutSafetyCheck;
            return this;
        }

        public final void setBypassPolicyLockoutSafetyCheck(Boolean bypassPolicyLockoutSafetyCheck) {
            this.bypassPolicyLockoutSafetyCheck = bypassPolicyLockoutSafetyCheck;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutFileSystemPolicyRequest build() {
            return new PutFileSystemPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EfsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutFileSystemPolicyRequest> {
        public Builder fileSystemId(String var1);

        public Builder policy(String var1);

        public Builder bypassPolicyLockoutSafetyCheck(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

