/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.efs.model.SecurityGroupsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyMountTargetSecurityGroupsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ModifyMountTargetSecurityGroupsRequest> {
    private final String mountTargetId;
    private final List<String> securityGroups;

    private ModifyMountTargetSecurityGroupsRequest(BuilderImpl builder) {
        this.mountTargetId = builder.mountTargetId;
        this.securityGroups = builder.securityGroups;
    }

    public String mountTargetId() {
        return this.mountTargetId;
    }

    public List<String> securityGroups() {
        return this.securityGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.mountTargetId() == null ? 0 : this.mountTargetId().hashCode());
        hashCode = 31 * hashCode + (this.securityGroups() == null ? 0 : this.securityGroups().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyMountTargetSecurityGroupsRequest)) {
            return false;
        }
        ModifyMountTargetSecurityGroupsRequest other = (ModifyMountTargetSecurityGroupsRequest)((Object)obj);
        if (other.mountTargetId() == null ^ this.mountTargetId() == null) {
            return false;
        }
        if (other.mountTargetId() != null && !other.mountTargetId().equals(this.mountTargetId())) {
            return false;
        }
        if (other.securityGroups() == null ^ this.securityGroups() == null) {
            return false;
        }
        return other.securityGroups() == null || other.securityGroups().equals(this.securityGroups());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.mountTargetId() != null) {
            sb.append("MountTargetId: ").append(this.mountTargetId()).append(",");
        }
        if (this.securityGroups() != null) {
            sb.append("SecurityGroups: ").append(this.securityGroups()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String mountTargetId;
        private List<String> securityGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyMountTargetSecurityGroupsRequest model) {
            this.setMountTargetId(model.mountTargetId);
            this.setSecurityGroups(model.securityGroups);
        }

        public final String getMountTargetId() {
            return this.mountTargetId;
        }

        @Override
        public final Builder mountTargetId(String mountTargetId) {
            this.mountTargetId = mountTargetId;
            return this;
        }

        public final void setMountTargetId(String mountTargetId) {
            this.mountTargetId = mountTargetId;
        }

        public final Collection<String> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
        }

        public ModifyMountTargetSecurityGroupsRequest build() {
            return new ModifyMountTargetSecurityGroupsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ModifyMountTargetSecurityGroupsRequest> {
        public Builder mountTargetId(String var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);
    }
}

