/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.efs.model.Tag;

public class TagUnmarshaller
implements Unmarshaller<Tag, JsonUnmarshallerContext> {
    private static final TagUnmarshaller INSTANCE = new TagUnmarshaller();

    public Tag unmarshall(JsonUnmarshallerContext context) throws Exception {
        Tag.Builder tagBuilder = Tag.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Key", targetDepth)) {
                    context.nextToken();
                    tagBuilder.key((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Value", targetDepth)) {
                    context.nextToken();
                    tagBuilder.value((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Tag)tagBuilder.build();
    }

    public static TagUnmarshaller getInstance() {
        return INSTANCE;
    }
}

