/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.efs.model.MountTargetDescription;
import software.amazon.awssdk.services.efs.model.MountTargetDescriptionsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeMountTargetsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeMountTargetsResponse> {
    private final String marker;
    private final List<MountTargetDescription> mountTargets;
    private final String nextMarker;

    private DescribeMountTargetsResponse(BuilderImpl builder) {
        this.marker = builder.marker;
        this.mountTargets = builder.mountTargets;
        this.nextMarker = builder.nextMarker;
    }

    public String marker() {
        return this.marker;
    }

    public List<MountTargetDescription> mountTargets() {
        return this.mountTargets;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.mountTargets() == null ? 0 : this.mountTargets().hashCode());
        hashCode = 31 * hashCode + (this.nextMarker() == null ? 0 : this.nextMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMountTargetsResponse)) {
            return false;
        }
        DescribeMountTargetsResponse other = (DescribeMountTargetsResponse)((Object)obj);
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.mountTargets() == null ^ this.mountTargets() == null) {
            return false;
        }
        if (other.mountTargets() != null && !other.mountTargets().equals(this.mountTargets())) {
            return false;
        }
        if (other.nextMarker() == null ^ this.nextMarker() == null) {
            return false;
        }
        return other.nextMarker() == null || other.nextMarker().equals(this.nextMarker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.mountTargets() != null) {
            sb.append("MountTargets: ").append(this.mountTargets()).append(",");
        }
        if (this.nextMarker() != null) {
            sb.append("NextMarker: ").append(this.nextMarker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String marker;
        private List<MountTargetDescription> mountTargets;
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMountTargetsResponse model) {
            this.setMarker(model.marker);
            this.setMountTargets(model.mountTargets);
            this.setNextMarker(model.nextMarker);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<MountTargetDescription> getMountTargets() {
            return this.mountTargets;
        }

        @Override
        public final Builder mountTargets(Collection<MountTargetDescription> mountTargets) {
            this.mountTargets = MountTargetDescriptionsCopier.copy(mountTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mountTargets(MountTargetDescription ... mountTargets) {
            this.mountTargets(Arrays.asList(mountTargets));
            return this;
        }

        public final void setMountTargets(Collection<MountTargetDescription> mountTargets) {
            this.mountTargets = MountTargetDescriptionsCopier.copy(mountTargets);
        }

        @SafeVarargs
        public final void setMountTargets(MountTargetDescription ... mountTargets) {
            this.mountTargets(Arrays.asList(mountTargets));
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public DescribeMountTargetsResponse build() {
            return new DescribeMountTargetsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeMountTargetsResponse> {
        public Builder marker(String var1);

        public Builder mountTargets(Collection<MountTargetDescription> var1);

        public Builder mountTargets(MountTargetDescription ... var1);

        public Builder nextMarker(String var1);
    }
}

