/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.efs.model.TagKeysCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteTagsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteTagsRequest> {
    private final String fileSystemId;
    private final List<String> tagKeys;

    private DeleteTagsRequest(BuilderImpl builder) {
        this.fileSystemId = builder.fileSystemId;
        this.tagKeys = builder.tagKeys;
    }

    public String fileSystemId() {
        return this.fileSystemId;
    }

    public List<String> tagKeys() {
        return this.tagKeys;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.fileSystemId() == null ? 0 : this.fileSystemId().hashCode());
        hashCode = 31 * hashCode + (this.tagKeys() == null ? 0 : this.tagKeys().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteTagsRequest)) {
            return false;
        }
        DeleteTagsRequest other = (DeleteTagsRequest)((Object)obj);
        if (other.fileSystemId() == null ^ this.fileSystemId() == null) {
            return false;
        }
        if (other.fileSystemId() != null && !other.fileSystemId().equals(this.fileSystemId())) {
            return false;
        }
        if (other.tagKeys() == null ^ this.tagKeys() == null) {
            return false;
        }
        return other.tagKeys() == null || other.tagKeys().equals(this.tagKeys());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.fileSystemId() != null) {
            sb.append("FileSystemId: ").append(this.fileSystemId()).append(",");
        }
        if (this.tagKeys() != null) {
            sb.append("TagKeys: ").append(this.tagKeys()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String fileSystemId;
        private List<String> tagKeys;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteTagsRequest model) {
            this.setFileSystemId(model.fileSystemId);
            this.setTagKeys(model.tagKeys);
        }

        public final String getFileSystemId() {
            return this.fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        public final Collection<String> getTagKeys() {
            return this.tagKeys;
        }

        @Override
        public final Builder tagKeys(Collection<String> tagKeys) {
            this.tagKeys = TagKeysCopier.copy(tagKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagKeys(String ... tagKeys) {
            this.tagKeys(Arrays.asList(tagKeys));
            return this;
        }

        public final void setTagKeys(Collection<String> tagKeys) {
            this.tagKeys = TagKeysCopier.copy(tagKeys);
        }

        @SafeVarargs
        public final void setTagKeys(String ... tagKeys) {
            this.tagKeys(Arrays.asList(tagKeys));
        }

        public DeleteTagsRequest build() {
            return new DeleteTagsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteTagsRequest> {
        public Builder fileSystemId(String var1);

        public Builder tagKeys(Collection<String> var1);

        public Builder tagKeys(String ... var1);
    }
}

