/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.efs.model.DescribeTagsRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DescribeTagsRequestModelMarshaller {
    private static final MarshallingInfo<Integer> MAXITEMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("MaxItems").isBinary(false).build();
    private static final MarshallingInfo<String> MARKER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("Marker").isBinary(false).build();
    private static final MarshallingInfo<String> FILESYSTEMID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("FileSystemId").isBinary(false).build();
    private static final DescribeTagsRequestModelMarshaller INSTANCE = new DescribeTagsRequestModelMarshaller();

    private DescribeTagsRequestModelMarshaller() {
    }

    public static DescribeTagsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DescribeTagsRequest describeTagsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)describeTagsRequest), (String)"describeTagsRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)describeTagsRequest.maxItems(), MAXITEMS_BINDING);
            protocolMarshaller.marshall((Object)describeTagsRequest.marker(), MARKER_BINDING);
            protocolMarshaller.marshall((Object)describeTagsRequest.fileSystemId(), FILESYSTEMID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

