/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.efs.model.CreateMountTargetRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateMountTargetRequestModelMarshaller {
    private static final MarshallingInfo<String> FILESYSTEMID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FileSystemId").isBinary(false).build();
    private static final MarshallingInfo<String> SUBNETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetId").isBinary(false).build();
    private static final MarshallingInfo<String> IPADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IpAddress").isBinary(false).build();
    private static final MarshallingInfo<List> SECURITYGROUPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecurityGroups").isBinary(false).build();
    private static final CreateMountTargetRequestModelMarshaller INSTANCE = new CreateMountTargetRequestModelMarshaller();

    private CreateMountTargetRequestModelMarshaller() {
    }

    public static CreateMountTargetRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateMountTargetRequest createMountTargetRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createMountTargetRequest), (String)"createMountTargetRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createMountTargetRequest.fileSystemId(), FILESYSTEMID_BINDING);
            protocolMarshaller.marshall((Object)createMountTargetRequest.subnetId(), SUBNETID_BINDING);
            protocolMarshaller.marshall((Object)createMountTargetRequest.ipAddress(), IPADDRESS_BINDING);
            protocolMarshaller.marshall(createMountTargetRequest.securityGroups(), SECURITYGROUPS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

