/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.efs.model.EFSRequest;
import software.amazon.awssdk.services.efs.model.SecurityGroupsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyMountTargetSecurityGroupsRequest
extends EFSRequest
implements ToCopyableBuilder<Builder, ModifyMountTargetSecurityGroupsRequest> {
    private final String mountTargetId;
    private final List<String> securityGroups;

    private ModifyMountTargetSecurityGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.mountTargetId = builder.mountTargetId;
        this.securityGroups = builder.securityGroups;
    }

    public String mountTargetId() {
        return this.mountTargetId;
    }

    public List<String> securityGroups() {
        return this.securityGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mountTargetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroups());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyMountTargetSecurityGroupsRequest)) {
            return false;
        }
        ModifyMountTargetSecurityGroupsRequest other = (ModifyMountTargetSecurityGroupsRequest)((Object)obj);
        return Objects.equals(this.mountTargetId(), other.mountTargetId()) && Objects.equals(this.securityGroups(), other.securityGroups());
    }

    public String toString() {
        return ToString.builder((String)"ModifyMountTargetSecurityGroupsRequest").add("MountTargetId", (Object)this.mountTargetId()).add("SecurityGroups", this.securityGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MountTargetId": {
                return Optional.of(clazz.cast(this.mountTargetId()));
            }
            case "SecurityGroups": {
                return Optional.of(clazz.cast(this.securityGroups()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EFSRequest.BuilderImpl
    implements Builder {
        private String mountTargetId;
        private List<String> securityGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyMountTargetSecurityGroupsRequest model) {
            super(model);
            this.mountTargetId(model.mountTargetId);
            this.securityGroups(model.securityGroups);
        }

        public final String getMountTargetId() {
            return this.mountTargetId;
        }

        @Override
        public final Builder mountTargetId(String mountTargetId) {
            this.mountTargetId = mountTargetId;
            return this;
        }

        public final void setMountTargetId(String mountTargetId) {
            this.mountTargetId = mountTargetId;
        }

        public final Collection<String> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ModifyMountTargetSecurityGroupsRequest build() {
            return new ModifyMountTargetSecurityGroupsRequest(this);
        }
    }

    public static interface Builder
    extends EFSRequest.Builder,
    CopyableBuilder<Builder, ModifyMountTargetSecurityGroupsRequest> {
        public Builder mountTargetId(String var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

