/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.efs.model.EFSResponse;
import software.amazon.awssdk.services.efs.model.MountTargetDescription;
import software.amazon.awssdk.services.efs.model.MountTargetDescriptionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeMountTargetsResponse
extends EFSResponse
implements ToCopyableBuilder<Builder, DescribeMountTargetsResponse> {
    private final String marker;
    private final List<MountTargetDescription> mountTargets;
    private final String nextMarker;

    private DescribeMountTargetsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.mountTargets = builder.mountTargets;
        this.nextMarker = builder.nextMarker;
    }

    public String marker() {
        return this.marker;
    }

    public List<MountTargetDescription> mountTargets() {
        return this.mountTargets;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.mountTargets());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMountTargetsResponse)) {
            return false;
        }
        DescribeMountTargetsResponse other = (DescribeMountTargetsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.mountTargets(), other.mountTargets()) && Objects.equals(this.nextMarker(), other.nextMarker());
    }

    public String toString() {
        return ToString.builder((String)"DescribeMountTargetsResponse").add("Marker", (Object)this.marker()).add("MountTargets", this.mountTargets()).add("NextMarker", (Object)this.nextMarker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "MountTargets": {
                return Optional.of(clazz.cast(this.mountTargets()));
            }
            case "NextMarker": {
                return Optional.of(clazz.cast(this.nextMarker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EFSResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<MountTargetDescription> mountTargets;
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMountTargetsResponse model) {
            super(model);
            this.marker(model.marker);
            this.mountTargets(model.mountTargets);
            this.nextMarker(model.nextMarker);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<MountTargetDescription.Builder> getMountTargets() {
            return this.mountTargets != null ? (Collection)this.mountTargets.stream().map(MountTargetDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder mountTargets(Collection<MountTargetDescription> mountTargets) {
            this.mountTargets = MountTargetDescriptionsCopier.copy(mountTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mountTargets(MountTargetDescription ... mountTargets) {
            this.mountTargets(Arrays.asList(mountTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mountTargets(Consumer<MountTargetDescription.Builder> ... mountTargets) {
            this.mountTargets(Stream.of(mountTargets).map(c -> (MountTargetDescription)((MountTargetDescription.Builder)MountTargetDescription.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMountTargets(Collection<MountTargetDescription.BuilderImpl> mountTargets) {
            this.mountTargets = MountTargetDescriptionsCopier.copyFromBuilder(mountTargets);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public DescribeMountTargetsResponse build() {
            return new DescribeMountTargetsResponse(this);
        }
    }

    public static interface Builder
    extends EFSResponse.Builder,
    CopyableBuilder<Builder, DescribeMountTargetsResponse> {
        public Builder marker(String var1);

        public Builder mountTargets(Collection<MountTargetDescription> var1);

        public Builder mountTargets(MountTargetDescription ... var1);

        public Builder mountTargets(Consumer<MountTargetDescription.Builder> ... var1);

        public Builder nextMarker(String var1);
    }
}

