/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.efs.model.EFSRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeMountTargetsRequest
extends EFSRequest
implements ToCopyableBuilder<Builder, DescribeMountTargetsRequest> {
    private final Integer maxItems;
    private final String marker;
    private final String fileSystemId;
    private final String mountTargetId;

    private DescribeMountTargetsRequest(BuilderImpl builder) {
        super(builder);
        this.maxItems = builder.maxItems;
        this.marker = builder.marker;
        this.fileSystemId = builder.fileSystemId;
        this.mountTargetId = builder.mountTargetId;
    }

    public Integer maxItems() {
        return this.maxItems;
    }

    public String marker() {
        return this.marker;
    }

    public String fileSystemId() {
        return this.fileSystemId;
    }

    public String mountTargetId() {
        return this.mountTargetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.mountTargetId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMountTargetsRequest)) {
            return false;
        }
        DescribeMountTargetsRequest other = (DescribeMountTargetsRequest)((Object)obj);
        return Objects.equals(this.maxItems(), other.maxItems()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.fileSystemId(), other.fileSystemId()) && Objects.equals(this.mountTargetId(), other.mountTargetId());
    }

    public String toString() {
        return ToString.builder((String)"DescribeMountTargetsRequest").add("MaxItems", (Object)this.maxItems()).add("Marker", (Object)this.marker()).add("FileSystemId", (Object)this.fileSystemId()).add("MountTargetId", (Object)this.mountTargetId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxItems": {
                return Optional.of(clazz.cast(this.maxItems()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "FileSystemId": {
                return Optional.of(clazz.cast(this.fileSystemId()));
            }
            case "MountTargetId": {
                return Optional.of(clazz.cast(this.mountTargetId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EFSRequest.BuilderImpl
    implements Builder {
        private Integer maxItems;
        private String marker;
        private String fileSystemId;
        private String mountTargetId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMountTargetsRequest model) {
            super(model);
            this.maxItems(model.maxItems);
            this.marker(model.marker);
            this.fileSystemId(model.fileSystemId);
            this.mountTargetId(model.mountTargetId);
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final String getFileSystemId() {
            return this.fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        public final String getMountTargetId() {
            return this.mountTargetId;
        }

        @Override
        public final Builder mountTargetId(String mountTargetId) {
            this.mountTargetId = mountTargetId;
            return this;
        }

        public final void setMountTargetId(String mountTargetId) {
            this.mountTargetId = mountTargetId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeMountTargetsRequest build() {
            return new DescribeMountTargetsRequest(this);
        }
    }

    public static interface Builder
    extends EFSRequest.Builder,
    CopyableBuilder<Builder, DescribeMountTargetsRequest> {
        public Builder maxItems(Integer var1);

        public Builder marker(String var1);

        public Builder fileSystemId(String var1);

        public Builder mountTargetId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

