/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.efs.model.EFSRequest;
import software.amazon.awssdk.services.efs.model.TagKeysCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteTagsRequest
extends EFSRequest
implements ToCopyableBuilder<Builder, DeleteTagsRequest> {
    private final String fileSystemId;
    private final List<String> tagKeys;

    private DeleteTagsRequest(BuilderImpl builder) {
        super(builder);
        this.fileSystemId = builder.fileSystemId;
        this.tagKeys = builder.tagKeys;
    }

    public String fileSystemId() {
        return this.fileSystemId;
    }

    public List<String> tagKeys() {
        return this.tagKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagKeys());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteTagsRequest)) {
            return false;
        }
        DeleteTagsRequest other = (DeleteTagsRequest)((Object)obj);
        return Objects.equals(this.fileSystemId(), other.fileSystemId()) && Objects.equals(this.tagKeys(), other.tagKeys());
    }

    public String toString() {
        return ToString.builder((String)"DeleteTagsRequest").add("FileSystemId", (Object)this.fileSystemId()).add("TagKeys", this.tagKeys()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FileSystemId": {
                return Optional.of(clazz.cast(this.fileSystemId()));
            }
            case "TagKeys": {
                return Optional.of(clazz.cast(this.tagKeys()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EFSRequest.BuilderImpl
    implements Builder {
        private String fileSystemId;
        private List<String> tagKeys;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteTagsRequest model) {
            super(model);
            this.fileSystemId(model.fileSystemId);
            this.tagKeys(model.tagKeys);
        }

        public final String getFileSystemId() {
            return this.fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        public final Collection<String> getTagKeys() {
            return this.tagKeys;
        }

        @Override
        public final Builder tagKeys(Collection<String> tagKeys) {
            this.tagKeys = TagKeysCopier.copy(tagKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagKeys(String ... tagKeys) {
            this.tagKeys(Arrays.asList(tagKeys));
            return this;
        }

        public final void setTagKeys(Collection<String> tagKeys) {
            this.tagKeys = TagKeysCopier.copy(tagKeys);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteTagsRequest build() {
            return new DeleteTagsRequest(this);
        }
    }

    public static interface Builder
    extends EFSRequest.Builder,
    CopyableBuilder<Builder, DeleteTagsRequest> {
        public Builder fileSystemId(String var1);

        public Builder tagKeys(Collection<String> var1);

        public Builder tagKeys(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

